import { LSSettingItems } from '../../../types';
import { GEO_POINTS } from '../../constants';
import { CSSettingsItems, CustomSettings } from '../../utils/customSettings';
import LS from '../../utils/localStorage/localStorage';
import { layerVectorCustomization } from './layerVectorCustomization';

declare let ymaps: any;

export const initMapApi = () => {
    const head = document.getElementsByTagName('head')[0];
    const scripts: any = head.getElementsByTagName('script');
    let mapScript: any = null;
    const isMapExist = [...scripts].some(script => {
        const src = script.getAttribute('src');
        if (src && src.includes(`https://api-maps.yandex.ru/2.1`)) {
            mapScript = script;

            return true;
        }

        return false;
    });

    if (!isMapExist) {
        mapScript = document.createElement('script');
        mapScript.src = `https://api-maps.yandex.ru/2.1/?load=package.full,vectorEngine.preload&lang=ru_RU&coordorder=longlat`;
        mapScript.crossorigin = 'anonymous';
        document.getElementsByTagName('head')[0].appendChild(mapScript);
    }

    return mapScript;
};

export const initMap = (id, callback) => {
    const mapScript = initMapApi();

    const ls = new LS();
    const city = ls.get(LSSettingItems.city);
    const customSetting = new CustomSettings();
    const isNightMode = customSetting.get(CSSettingsItems.nightMode);
    const mapCenter = GEO_POINTS[city].OPTIONS.center;
    const zoom = GEO_POINTS[city].OPTIONS.zoom;
    const vectorConfig = {
        vector: true,
        layerVectorRevealThreshold: 0,
        ...isNightMode ? { layerVectorMode: 'night' } : { layerVectorCustomization },
    };

    const createMap = () => {
        // @ts-ignore
        window.ymaps.ready(() => {
            const map = new ymaps.Map(id,
                {
                    center: mapCenter,
                    zoom: zoom,
                    controls: [],
                }, {
                    minZoom: 5,
                    maxZoom: 19,
                    suppressMapOpenBlock: true,
                    copyrightLogoVisible: false,
                    copyrightProvidersVisible: false,
                    copyrightUaVisible: false,
                    ...vectorConfig,
                });
            map.layers.events.add('vectorerror', () => console.error('Не удалось отобразить векторную подложку.'));
            callback(map);
        });
    };

    // @ts-ignore
    if (window.ymaps) {
        createMap();
    } else {
        mapScript.addEventListener('load', () => {
            createMap();
        });
    }
};

export const fillColor = (props: { area_tags: string }) => {
    const { area_tags } = props;

    return area_tags.indexOf('sup_fee') > -1
        ? '#0000FF60'
        : area_tags.indexOf('allow_riding') > -1
            ? '#00FF0010'
            : area_tags.indexOf('allow_drop') > -1
                ? '#00FF0030'
                : area_tags.indexOf('impoundment_lot') > -1
                    ? '#FAA00020'
                    : area_tags.indexOf('shuttle_deny_drop_car') == 0
                        ? '#ffafff60'
                        : area_tags.indexOf('deny_drop_car') > -1
                            ? '#FF000060'
                            : '#0000FF10';
};

export const stroke = (item: any) => item.indexOf('surge') > -1 ? '#0000FF40' : '#0000FF20';
