import produce from 'immer';
import * as React from 'react';
import Scrollbars from 'react-custom-scrollbars';

import { ISearchControls, WithSearchControls } from '../../../../decorators/SearchControls';
import { ONE_SECOND } from '../../../constants';
import FormatDate from '../../../ui/FormatDate';
import { Window } from '../../../ui/FullModal';
import { NoInformation } from '../../../ui/NoInformation';
import { LabelStatus, TLabel } from '../../../ui/Table';
import * as tblStyle from '../../../ui/Table/index.css';
import { Request2 } from '../../../utils/request';
import { SimpleError } from '../../SimpleError';
import Spin from '../../Spin';
import { MAJOR_REQUESTS, REQUESTS } from '../request';
import * as style from './index.css';

type IProps = ISearchControls

interface IState {
    isLoading: boolean;
    data: any;
    error: any;
    showEntities: boolean;
    selectedEntities: any;
}

@WithSearchControls()
export class Wheels extends React.Component<IProps, IState> {
    state = {
        isLoading: false,
        data: {} as any,
        error: null,

        showEntities: false,
        selectedEntities: {},
    };
    request = new Request2({ requestConfigs: MAJOR_REQUESTS });

    getData(props: IProps) {
        this.setState(produce(this.state, draft => {
            draft.isLoading = true;
            draft.error = null;
        }), () => {
            this.request.exec(REQUESTS.GET_WHEELS, {
                queryParams: {
                    since: props.since,
                    until: props.until,
                },
            })
                .then(response => {
                    this.setState(produce(this.state, draft => {
                        draft.isLoading = false;
                        draft.data = response;
                    }));
                })
                .catch(error => {
                    this.setState(produce(this.state, draft => {
                        draft.isLoading = false;
                        draft.error = error;
                    }));
                });
        });
    }

    getLabelStatus(status) {
        switch (status) {
        case 'NoDamage':
        case 'WheelReady':
            return LabelStatus.POSITIVE;
        case 'Destroyed':
        case 'Missing':
            return LabelStatus.NEGATIVE;
        case 'Diagnostic':
            return LabelStatus.WARNING;
        case 'RepairAtStorage':
        case 'RepairOnPlace':
            return LabelStatus.INFO;
        default:
            return LabelStatus.DEFAULT;
        }
    }

    componentDidMount(): void {
        this.getData(this.props);
    }

    UNSAFE_componentWillReceiveProps(nextProps: Readonly<IProps>, nextContext: any): void {
        if (nextProps.since !== this.props.since || nextProps.until !== this.props.until) {
            this.getData(nextProps);
        }
    }

    showItems(i, item: any) {
        this.setState(produce(this.state, draft => {
            draft.showEntities = true;
            draft.selectedEntities = { item, i } || {};
        }));
    }

    getSybRows(item, index) {
        const { statuses } = item;

        return statuses
            && Array.isArray(statuses)
            && statuses.map((i, _index) => {
                const rim_status = this.getLabelStatus(i.status);

                return <tr key={`${index}_${_index}`}
                           className={style.item}
                           onClick={this.showItems.bind(this, i, item)}>
                    <td/>
                    <td>
                        <TLabel status={rim_status}
                                text={i.status}
                                className={style.rim_status_label}/>
                        <span> <strong>{i.count}</strong></span>
                    </td>
                    <td/>
                    <td/>
                </tr>;
            }) || [];
    }

    onClose() {
        this.setState(produce(this.state, draft => {
            draft.showEntities = false;
        }));
    }

    render() {
        const rims = this.state.data
            && this.state.data.rims
            && Array.isArray(this.state.data.rims)
            && this.state.data.rims || [];

        const tyres = this.state.data
            && this.state.data.tyres
            && Array.isArray(this.state.data.tyres)
            && this.state.data.tyres || [];

        return <div className={style.component}>
            {
                this.state.showEntities &&
                <ShowEntities obj={this.state.selectedEntities} onClose={this.onClose.bind(this)}/>
            }
            {
                this.state.isLoading
                    ? <Spin/>
                    : this.state.error
                        ? <SimpleError error={this.state.error}/>
                        : <div className={style.tables}>
                            <div className={style.rim_table}>
                                <div><strong>Rims:</strong> {rims.length}</div>
                                {rims?.length
                                    ? <Scrollbars style={{ maxHeight: 'calc(100vh - 250px)' }} autoHide>
                                        <table className={`${tblStyle.table}`}>
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>model</th>
                                                    <th>type</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                {
                                                    rims
                                                        .map((item: any, index) => {
                                                            const { model = '', type = '' } = item.type_info || {};

                                                            const row = <tr key={index}>
                                                                <td>{++index}</td>
                                                                <td className={style.brand}> {model} </td>
                                                                <td className={style.rim_type}>{type}</td>
                                                                <td/>
                                                                <td/>
                                                            </tr>;

                                                            return [row, ...this.getSybRows(item, index)];
                                                        })
                                                }
                                            </tbody>
                                        </table>
                                    </Scrollbars>
                                    : <NoInformation/>
                                }
                            </div>
                            <div className={style.tyre_table}>
                                <div><strong>Tyres:</strong> {tyres.length}</div>
                                {tyres?.length
                                    ? <Scrollbars style={{ maxHeight: 'calc(100vh - 250px)' }} autoHide>
                                        <table className={`${tblStyle.table}`}>
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>brand/model</th>
                                                    <th>size</th>
                                                    <th>season</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                {
                                                    tyres
                                                        .map((item: any, index) => {
                                                            const {
                                                                brand = '',
                                                                model = '',
                                                                size = '',
                                                                season = '',
                                                            } = item.type_info || {};
                                                            const row = <tr key={index}>
                                                                <td>{++index}</td>
                                                                <td>
                                                                    <div className={style.brand}>{brand}</div>
                                                                    <div className={style.model}>{model}</div>
                                                                </td>

                                                                <td>{size}</td>
                                                                <td>{season}</td>
                                                            </tr>;

                                                            return [row, ...this.getSybRows(item, index)];
                                                        })
                                                }
                                            </tbody>
                                        </table>
                                    </Scrollbars>
                                    : <NoInformation/>
                                }
                            </div>
                        </div>
            }
        </div>;
    }
}

const ShowEntities = React.memo((props: { obj: any; onClose: () => void }) => {
    const type_info = props.obj && props.obj.item && props.obj.item.type_info || {};

    return <Window onClose={props.onClose} title={`${type_info.brand}, ${type_info.model}, ${props.obj.i.status}`}>
        <div className={style.entities}>
            <ul>
                {
                    props.obj.i
                    && props.obj.i.entities
                    && Array.isArray(props.obj.i.entities)
                    && props.obj.i.entities
                        .map((item, index) => {
                            return <li key={index}>
                                <span className={style.entities_item_id}>{item.query_id}: </span>
                                <FormatDate value={
                                    item.create_date * ONE_SECOND
                                }/> - <FormatDate value={
                                    item.close_date * ONE_SECOND
                                }/>
                            </li>;
                        }) || null
                }
            </ul>
        </div>
    </Window>;
});
