import { IComponentRequest } from '../../utils/request';

export const REQUESTS: { [key: string]: string } = {
    GET_WHEELS: 'GET_WHEELS',
    SERVICE: 'SERVICE',
    STORAGE: 'STORAGE',
};

const MAJOR_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_WHEELS]: {
        api: 'major/tyre_info',
        cgiObj: {
            since: null,
            until: null,
        },
    },
    [REQUESTS.SERVICE]: {
        api: 'major/get',
        cgiObj: {
            all: 'false',
        },
    },
    [REQUESTS.STORAGE]: {
        api: 'major/tyre_storage',
        cgiObj: {
            regions: null,
            storage: null,
        },
    },
};

export { MAJOR_REQUESTS };
