import { getDuration } from '../../../utils/utils';

export const getOfferId = (content) => {
    return `${content?.offer_group_name ? `${content.offer_group_name}.` : content?.group_name ? `${content.group_name}.` : ''}` +
        `${content?.offer_name ? `${content.offer_name}` : `${content?.name ? `${content.name}` : ''}`}`;
};

export const offerNameSeparator = '%*#';

export const shouldDisplayCar = (currentFiltersKeys, currentFilters, car): boolean => {
    return currentFiltersKeys.length ? currentFiltersKeys
        ?.filter((key) => currentFilters[key] !== '')
        ?.every((filter) => {
            if (filter === 'idle_start') {
                return currentFilters?.[filter][0] < getDuration(car?.surge?.[filter])
                    && currentFilters?.[filter][1] > getDuration(car?.surge?.[filter]);
            }

            if (filter === 'offer_name') {
                return currentFilters[filter].split(offerNameSeparator).some((offer) => {
                    return getOfferId(car) === offer;
                });
            }

            return car?.[filter] === currentFilters?.[filter];

        }) : true;
};
