import { GEO_POINTS, SHORT_GEO_POINTS } from '../../../../constants';

declare let ymaps;

export const drawCityControl = (map, shortList?: boolean) => {
    const geoPoints = !shortList ? GEO_POINTS : SHORT_GEO_POINTS;
    const citiesPoints = Object.keys(geoPoints).map(keyCity => {
        return new ymaps.control.ListBoxItem({
            data: { content: geoPoints[keyCity].LABEL.normal },
            state: { selected: false, keyCity },
        });
    });

    const cityList = [
        new ymaps.control.ListBoxItem({
            data: { content: 'Все города' }, state: { selected: false, keyCity: null },
        }), ...citiesPoints];

    const city = new ymaps.control.ListBox({
        data: {
            content: 'Города',
        },
        items: cityList,
    });
    city.events.add(['select'], e => {
        const current = e.get('target').state.get('keyCity');
        const iterator = city.getIterator();
        let obj;
        while ((obj = iterator.getNext()) !== iterator.STOP_ITERATION) {
            if (obj.state.get('keyCity') !== current) {
                obj.deselect();
            }
        }

        if (current) {
            map.setCenter(geoPoints[current].OPTIONS.center, geoPoints[current].OPTIONS.zoom);
        } else {
            const bounds = map.geoObjects.getBounds();
            bounds && map.setBounds(bounds);
        }

        while ((obj = iterator.getNext()) != iterator.STOP_ITERATION) {
            obj.enable();
        }
    });
    map.controls.add(city, { float: 'right' });
};
