import XLSX from 'xlsx';

import { EMPTY_DATA, ONE_SECOND } from '../../../../constants';
import LS from "../../../../utils/localStorage/localStorage";
import { WIDTH_MAP_CONTROL } from '../../helpers/widthMapControl';

declare let ymaps;

export const downloadCarsXLSX = (data, hasComments = false) => {
    const ls = new LS();
    const isScooters = ls.envIsScooter();
    const wb = XLSX.utils.book_new();
    const ws_data: any = [];

    ws_data.push([
        'id',
        'number',
        'model_id',
        'status',
        'usage',
        'surge.kff',
        'surge.l_kff',
        'surge.idle_start',
        'idle_start',
        'fuel',
        'vin',
        'imei',
        'mileage',
        hasComments ? 'tag' : '',
        hasComments ? 'comment' : '',
        isScooters ? 'lat' : '',
        isScooters ? 'lon' : '',
    ]);

    data.forEach((_c: any) => {
        const car = (_c?.properties?.car || _c) ?? {};
        const surge = car?.surge ?? {};
        const idle_start = new Date(surge?.idle_start * ONE_SECOND)?.toLocaleString() ?? EMPTY_DATA;
        const fuel = car?.telematics?.fuel_level ?? EMPTY_DATA;
        const mileage = car?.telematics?.mileage ?? EMPTY_DATA;
        const row = [
            car.id,
            car.number,
            car.model_id,
            car.status,
            car.usage,
            surge?.kff ?? EMPTY_DATA,
            surge?.l_kff ?? EMPTY_DATA,
            surge?.idle_start ?? EMPTY_DATA,
            idle_start,
            fuel,
            car.vin,
            car.imei,
            mileage,
            hasComments ? (car?.tags?.[0]?.tag ?? '') : '',
            hasComments ? (car?.tags?.[0]?.comment ?? '') : '',
            isScooters ? (car?.location?.lat ?? '') : '',
            isScooters ? (car?.location?.lon ?? '') : '',
        ];
        const additional: any[] = [];
        if (car?.tags?.length > 1 && hasComments) {
            for (let index = 1; index < car?.tags?.length; index++) {
                additional.push([
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    hasComments ? (car?.tags?.[index]?.tag ?? '') : '',
                    hasComments ? (car?.tags?.[index]?.comment ?? '') : '',
                ]);
            }
        }

        ws_data.push(row, ...additional);
    });

    const ws = XLSX.utils.aoa_to_sheet(ws_data);
    XLSX.utils.book_append_sheet(wb, ws, 'Машины');

    XLSX.writeFile(wb, `cars-${data.length}.xlsx`);
};

export const drawDownloadControl = (map, objectManager) => {
    const Download = new ymaps.control.Button({
        data: { content: 'Скачать' },
        options: {
            maxWidth: WIDTH_MAP_CONTROL,
        },
        state: {
            selected: false,
        },
    });

    Download.events
        .add('select', () => {
            const data: any[] = [];
            objectManager.objects.each((_el: any) => {
                !objectManager.getObjectState(_el.id).isFilteredOut &&
                data.push(_el);
            });

            downloadCarsXLSX(data);

            Download.deselect();
        });

    map.controls.add(Download, { float: 'right' });

    return Download;
};
