import { Request2 } from '../../../../utils/request';
import { REQUESTS } from '../../../MainMap/request';
import { MAP_REQUESTS } from '../../request';

declare let ymaps;

export const drawFuelStationsControl = (map,
    fuelStationsCollection,
    state?: () => [],
    handler?: (value) => void,
    errorHandler?: (error) => void) => {
    const request = new Request2({ requestConfigs: MAP_REQUESTS });

    const fuelStations = new ymaps.control.Button({
        data: {
            content: 'Заправки',
        },
    });

    const template = (className: string) => `<div class='${className}'>
            <div>название: <strong>{{properties.item.name}}</strong></div> 
            <div>адрес: <strong>{{properties.item.address}}</strong></div>
            <div>колонок: 
                <strong class=\'ft\'>
                    {{properties.message.count}}: {{properties.message.ft}}
                </strong>
            </div>
        </div>`;

    const BalloonContentLayout = ymaps.templateLayoutFactory.createClass(template(''), {});

    const fuelStationsFromState = (state && state()) ?? [];

    fuelStations.events.add('select', () => {
        if (!fuelStationsFromState?.length) {
            request.exec(REQUESTS.GET_FUELING)
                .then(response => {
                    fuelStations.enable();
                    const stations = response?.map?.stations ?? [];
                    fuelStations.data.set('content', `Заправки (${stations.length})`);

                    const stationsObject = stations.map((item: any) => {
                        const id = item.location.replace(/[.|\s]/ig, '-');

                        return {
                            type: 'Feature',
                            id,
                            geometry: {
                                type: 'Point',
                                coordinates: item.location.split(' '),
                            },
                            properties: {
                                id,
                                item,
                                message: {
                                    count: item.columns && item.columns.length || 0,
                                    ft: [...new Set(item.columns
                                        .reduce((_p: string[], _c: any) => {
                                            return [..._p, ..._c.ft];
                                        }, []))].join(', '),
                                },
                            },
                            options: {
                                balloonContentLayout: BalloonContentLayout,
                                preset: 'islands#blueFuelStationCircleIcon',
                            },
                        };
                    });

                    fuelStationsCollection.add(stationsObject);

                    if (handler) {
                        handler(stationsObject);
                    }

                    if (errorHandler) {
                        errorHandler(null);
                    }
                })
                .catch((error) => {
                    if (errorHandler) {
                        errorHandler(error);
                    }
                });
        } else {
            fuelStationsCollection.add(fuelStationsFromState);
        }
    });

    fuelStations.events.add(['deselect'], () => {
        fuelStationsCollection.removeAll();
    });

    map.controls.add(fuelStations, { float: 'right' });

    return fuelStations;
};
