import { WIDTH_MAP_CONTROL } from '../../helpers/widthMapControl';

declare let ymaps: any;

export const drawShowAllControl = (map: any) => {
    const showAll = new ymaps.control.Button({
        data: { content: 'Вместить на карту' },
        options: {
            maxWidth: WIDTH_MAP_CONTROL,
        },
    });
    showAll.events.add('select', () => {
        map.setBounds(map.geoObjects.getBounds());
        showAll.deselect();
    });
    map.controls.add(showAll, { float: 'right' });

    return showAll;
};
