import { ICar } from '../../../../../types';
import { ONE_HOUR, ONE_SECOND } from '../../../../constants';
import { deepCopy, getDuration } from '../../../../utils/utils';

const ONE_HOUR_SEC = ONE_HOUR / ONE_SECOND;

const IDLE_FILTERS_HOURS = {
    ONE_HOUR: 1,
    TWO_HOURS: 2,
    THREE_HOURS: 3,
    SIX_HOURS: 6,
    NINE_HOURS: 9,
    '24_HOURS': 24,
};

export const colorizeIdlePreset = (car: ICar) => {
    const IDLE_FILTERS = Object.keys(IDLE_FILTERS_HOURS)?.reduce((acc, key) => {
        acc[key] = IDLE_FILTERS_HOURS[key] * ONE_HOUR_SEC;

        return acc;
    }, deepCopy(IDLE_FILTERS_HOURS));

    let preset = `islands#grayCircleDotIcon`;

    if (car?.surge?.idle_start) {
        const duration = getDuration(car.surge.idle_start);

        if (duration > 0 && duration < IDLE_FILTERS.ONE_HOUR) {
            preset = `islands#greenCircleDotIcon`;
        } else if (duration >= IDLE_FILTERS.ONE_HOUR && duration < IDLE_FILTERS.TWO_HOURS) {
            preset = `islands#blueCircleDotIcon`;
        } else if (duration >= IDLE_FILTERS.TWO_HOURS && duration < IDLE_FILTERS.THREE_HOURS) {
            preset = `islands#yellowCircleDotIcon`;
        } else if (duration >= IDLE_FILTERS.THREE_HOURS && duration < IDLE_FILTERS.SIX_HOURS) {
            preset = `islands#redCircleDotIcon`;
        } else if (duration >= IDLE_FILTERS.SIX_HOURS && duration < IDLE_FILTERS.NINE_HOURS) {
            preset = `islands#pinkCircleDotIcon`;
        } else if (duration >= IDLE_FILTERS.NINE_HOURS && duration < IDLE_FILTERS['24_HOURS']) {
            preset = `islands#brownCircleDotIcon`;
        } else if (duration >= IDLE_FILTERS['24_HOURS']) {
            preset = `islands#blackCircleDotIcon`;
        }
    }

    return preset;
};
