import React from 'react';
import { render } from 'react-dom';

import { CarTooltip } from '../../CarTooltip';

const OFFSET = 10;
const TOOLTIP_WIDTH = 250;
const VIEWPORT_OFFSET = 50;
const TOOLTIP_HEIGHT = 400;

export const showCarTooltip = (x, y, car, carTooltip, modelsData, map) => {
    const mapSize = map?.container?.getSize() || [];
    const width = mapSize[0];

    carTooltip.element.style.display = 'block';
    carTooltip.element.style.top = y - TOOLTIP_WIDTH - OFFSET + 'px';

    if (carTooltip.element && (x + TOOLTIP_WIDTH > width)) {
        carTooltip.element.style.left = `${x - TOOLTIP_WIDTH - OFFSET}px`;
    } else {
        carTooltip.element.style.left = `${x + OFFSET}px`;
    }

    if (carTooltip.element && y - TOOLTIP_HEIGHT < VIEWPORT_OFFSET) {
        carTooltip.element.style.top = `${y + OFFSET}px`;
    } else {
        carTooltip.element.style.top = `${y - TOOLTIP_WIDTH - OFFSET}px`;
    }

    render(<CarTooltip car={car} modelsData={modelsData}/>, carTooltip.element);
};
