import { connect } from 'react-redux';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../constants';
import { getRawSetting2 } from '../../utils/getRawSetting';
import { IStore } from '../App/store';
import { polyFiltersKey } from '../InterfaceAdminConfig/adminConfigKeys';
import { Map2 } from './component';

const SETTINGS_KEY = `${GVARS_INTERFACE_ADMIN_PREFIX}.${polyFiltersKey}`;

export const mapStateToProps = (store: IStore) => {
    const polyFilters = getRawSetting2(store, SETTINGS_KEY);

    return {
        polyFilters,
        AdminUser: store?.AdminUser,
    };
};

export default connect(mapStateToProps)(Map2);
