import * as React from 'react';

import style from './index.css';

export const Burger = (props: any) => {
    const burgerState = `${style.burger_menu} ${(props.active && style.menu_on || '')}`;

    return <div className={burgerState}>
        <div className={style.burger} />
    </div>;
};

export interface IPropsUserMenu {
    active: boolean;
    toggleSideBar: (state: boolean) => void;
    openUserInfoModal?: () => void;
}

interface IPropsAbstractMenu extends IPropsUserMenu {
    menuId: string;
}

export class AbstractMenuSideBar extends React.Component <IPropsAbstractMenu, any> {
    myRef: any = null;

    constructor(props: any) {
        super(props);
        this.myRef = React.createRef();
    }

    toggleSideBar(e) {
        if(!this.myRef?.current?.contains?.(e.target)) {
            this.props.toggleSideBar(false);
        }
    }

    componentDidMount() {
        document.body.addEventListener('click', this.toggleSideBar.bind(this));
    }

    componentDidUpdate(prevProps: Readonly<IPropsAbstractMenu>, prevState: Readonly<any>) {
        if (prevProps.active !== this.props.active) {
            this.props.active && this.myRef.current.focus();
        }
    }

    componentWillUnmount(): void {
        document.body.removeEventListener('click', this.toggleSideBar.bind(this));
    }

    onKeyUp(e: KeyboardEvent) {
        if (e.key === 'Escape') {
            this.props.toggleSideBar(false);
        }
    }

    render() {
        const menuState = `${style.menu} ${style[this.props.menuId] ?? ''} ${(this.props.active && style.active || '')}`;

        return <div tabIndex={-1}
                    className={menuState}
                    ref={this.myRef}
                    onKeyUp={this.onKeyUp.bind(this)}>
            {this.props.children}
        </div>;
    }
}
