import * as React from 'react';

import { Confirm } from '../../../ui/FullModal';

interface IDuplicateDialogProps {
    duplicates: string[];
    showDialog: () => void;
    onClose: () => void;
}

export const DuplicateDialog = (props: IDuplicateDialogProps) => {
    const { duplicates, showDialog, onClose } = props;

    return (
        <Confirm question={`Сущности с следующими названиями уже существуют на хосте назначения: ${duplicates.join(' ')}`}
                 error={null}
                 accept={showDialog.bind(null)}
                 onClose={onClose.bind(null)}
                 acceptTitle={'Все равно перенести'}/>
    );
};
