import React from 'react';

import Checkbox from '../../../../ui/Checkbox';
import { IsChecked } from '../../../../ui/IsChecked';
import { isObjectEqual } from '../../../../utils/isObjectEqual';
import * as _style from '../../index.css';
import { ITEM_SIZE } from '../types';

interface IEntityItemProps {
    index: number;
    style: any;
    item: any;
    setEntity: (item, state) => void;
    selectedEntities: any;
    moveSource: string[];
    descriptionKey: string;
    descriptionGetter?: (el) => any;
    setHeight: (height: number, index: number) => void;
}

interface IEntityItemState {
    isChecked: boolean;
}

export class EntityItem extends React.Component<IEntityItemProps, IEntityItemState> {
    state: IEntityItemState = {
        isChecked: false,
    };

    entityNameRef = React.createRef<HTMLSpanElement>();
    descriptionRef = React.createRef<HTMLSpanElement>();

    componentDidUpdate(prevProps: Readonly<IEntityItemProps>) {
        if (!isObjectEqual(this.props.selectedEntities, prevProps.selectedEntities)
            || !isObjectEqual(this.props.item, prevProps.item)) {
            this.setState({
                isChecked: !!this.props.selectedEntities[this.props.item[0]],
            });
        }
    }

    componentDidMount() {
        this.setState({
            isChecked: !!this.props.selectedEntities[this.props.item[0]],
        });

        if (this.descriptionRef?.current?.clientHeight && this.entityNameRef?.current?.clientHeight) {
            const maxHeight = this.descriptionRef?.current?.clientHeight >= this.entityNameRef?.current?.clientHeight
                ? this.descriptionRef?.current?.clientHeight
                : this.entityNameRef?.current?.clientHeight;
            this.props.setHeight(maxHeight, this.props.index);
        } else {
            this.props.setHeight(ITEM_SIZE, this.props.index);
        }
    }

    onChange(isChecked) {
        this.setState({
            isChecked,
        }, () => {
            this.props.setEntity(this.props.item, isChecked);
        });
    }

    render() {
        const { index, style, item, descriptionGetter } = this.props;
        const obj = item[1];
        const isAllowDirection = !!obj[this.props.moveSource[0]];

        let displayName = obj?.prestable?.[this.props.descriptionKey]
            || obj?.testing?.[this.props.descriptionKey]
            || obj?.qa?.[this.props.descriptionKey]
            || obj?.st?.[this.props.descriptionKey]
            || obj?.['leasing-cabinet']?.[this.props.descriptionKey]
            || obj?.dm_test?.[this.props.descriptionKey]
            || obj?.dm_prestable?.[this.props.descriptionKey];

        if (descriptionGetter) {
            displayName = descriptionGetter?.(obj?.prestable)
                || descriptionGetter?.(obj?.testing)
                || descriptionGetter?.(obj?.qa)
                || descriptionGetter?.(obj?.st)
                || descriptionGetter?.(obj?.['leasing-cabinet'])
                || descriptionGetter?.(obj?.dm_test)
                || descriptionGetter?.(obj?.prestable);
        }

        return <div style={style}
                    className={`${_style.row} ${isAllowDirection ? _style.allow : _style.deny}`}>
            <span>{index + 1}</span>
            <span>
                <Checkbox checked={this.state.isChecked}
                          onChange={this.onChange.bind(this)}
                          disabled={!isAllowDirection}/>
            </span>
            <span>
                <IsChecked checked={!!obj.prestable}/>
            </span>
            <span>
                <IsChecked checked={!!obj.testing}/>
            </span>
            <span>
                <IsChecked checked={!!obj.st}/>
            </span>
            <span>
                <IsChecked checked={!!obj.qa}/>
            </span>
            <span>
                <IsChecked checked={!!obj['leasing-cabinet']}/>
            </span>
            <span>
                <IsChecked checked={!!obj.dm_prestable}/>
            </span>
            <span>
                <IsChecked checked={!!obj.dm_test}/>
            </span>
            <span ref={this.entityNameRef}>
                {item[0]}
            </span>
            <span ref={this.descriptionRef}>
                {displayName}
            </span>
        </div>;
    }
}
