import React from 'react';

import { EXTRA_ENV } from '../../../../types';
import { Request2 } from '../../../utils/request';
import QueryScheduler, { COUNT_FIRST } from '../../QueryScheduler/QueryScheduler';
import { HOST } from '../constants';
import MoveEntity from '../index';
import * as _style from '../index.css';
import { MIGRATE_REQUESTS, REQUESTS } from '../request';

interface IMoveActionsState {
    result: any;
}

export class MoveActions extends React.Component<IMoveActionsState> {
    state: IMoveActionsState = {
        result: [],
    };

    request = new Request2({ requestConfigs: MIGRATE_REQUESTS });

    async getActions(requestQueue: (queue: Promise<unknown>[]) => any) {
        const hostsKeys = Object.keys(HOST);
        const queue = hostsKeys.map((key) => (
            this.request.exec(REQUESTS.GET_ACTIONS, {
                headers: { 'saasnew': HOST[key.toUpperCase()] },
                queryParams: Object.assign({}, EXTRA_ENV[key.toUpperCase()]?.cgi ?? {}, { report: 'common' }),
                removeExtraCgi: true,
            })
        ));
        const response = await requestQueue(queue);
        const result = {};

        response?.forEach((host_res, index) => {
            host_res?.report?.forEach((el) => {
                if (!el?.propositions?.length) {
                    if (result.hasOwnProperty(el.action_id)) {
                        result[el.action_id][hostsKeys[index].toLowerCase()] = el;
                    } else {
                        result[el.action_id] = {
                            [hostsKeys[index].toLowerCase()]: el,
                        };
                    }
                }
            });
        });

        this.setState({
            result,
        });
    }

    moveActions(entities, envTo, onProgress, onSuccess) {
        const queue = entities
            .map((body) => this.request.exec.bind(this.request, REQUESTS.ADD_ACTION,
                {
                    body,
                    headers: { 'saasnew': HOST[envTo.toUpperCase()] },
                    queryParams: EXTRA_ENV[envTo.toUpperCase()]?.cgi ?? null,
                    removeExtraCgi: true,
                }),
            );

        const qs = new QueryScheduler({
            queue,
            limit: COUNT_FIRST,
            onProgress: onProgress.bind(this),
            onSuccess: onSuccess.bind(this),
        });

        qs.run();
    }

    proposeActions(entities, envTo, onProgress, onSuccess, comment) {
        const queue = entities
            .map((body) => this.request.exec.bind(this.request, REQUESTS.ADD_ACTION_PROPOSE,
                {
                    queryParams: Object.assign({}
                        , EXTRA_ENV[envTo.toUpperCase()]?.cgi ?? {}
                        , { comment: encodeURIComponent(comment) }),
                    body,
                    headers: { 'saasnew': HOST[envTo.toUpperCase()] },
                    removeExtraCgi: true,
                }),
            );

        const qs = new QueryScheduler({
            queue,
            limit: COUNT_FIRST,
            onProgress: onProgress.bind(this),
            onSuccess: onSuccess.bind(this),
        });

        qs.run();
    }

    render() {
        return <div className={_style.component}>
            <MoveEntity descriptionKey={'action_description'}
                        result={this.state.result}
                        getEntityList={this.getActions.bind(this)}
                        moveEntities={this.moveActions.bind(this)}
                        proposeEntities={this.proposeActions.bind(this)}/>
        </div>;
    }
}
