import React from 'react';

import { EXTRA_ENV } from '../../../../types';
import { Request2 } from '../../../utils/request';
import QueryScheduler, { COUNT_FIRST } from '../../QueryScheduler/QueryScheduler';
import { HOST } from '../constants';
import MoveEntity from '../index';
import * as _style from '../index.css';
import { MIGRATE_REQUESTS, REQUESTS } from '../request';

interface IMoveActionsState {
    result: any;
}

export class MoveAreas extends React.Component<IMoveActionsState> {
    state: IMoveActionsState = {
        result: [],
    };

    request = new Request2({ requestConfigs: MIGRATE_REQUESTS });

    async getAreas(requestQueue: (queue: Promise<unknown>[]) => any) {
        const hostsKeys = Object.keys(HOST);
        const queue = hostsKeys.map((key) => (
            this.request.exec(REQUESTS.GET_AREAS, {
                headers: { 'saasnew': HOST[key.toUpperCase()] },
                queryParams: EXTRA_ENV[key.toUpperCase()]?.cgi ?? null,
                removeExtraCgi: true,
            })
        ));
        const response = await requestQueue(queue);
        const result = {};

        response?.forEach((host_res, index) => {
            host_res?.areas?.forEach((el) => {
                if (!el?.propositions?.length) {
                    if (result.hasOwnProperty(el.area_id)) {
                        result[el.area_id][hostsKeys[index].toLowerCase()] = el;
                    } else {
                        result[el.area_id] = {
                            [hostsKeys[index].toLowerCase()]: el,
                        };
                    }
                }
            });
        });

        this.setState({
            result,
        });
    }

    moveAreas(entities, envTo, onProgress, onSuccess) {
        const queue = entities
            .map((body) => this.request.exec.bind(this.request, REQUESTS.ADD_AREA,
                {
                    body: { areas: [body] },
                    headers: { 'saasnew': HOST[envTo.toUpperCase()] },
                    queryParams: EXTRA_ENV[envTo.toUpperCase()]?.cgi ?? null,
                    removeExtraCgi: true,
                }),
            );

        const qs = new QueryScheduler({
            queue,
            limit: COUNT_FIRST,
            onProgress: onProgress.bind(this),
            onSuccess: onSuccess.bind(this),
        });

        qs.run();
    }

    proposeAreas(entities, envTo, onProgress, onSuccess, comment) {
        const queue = entities
            .map((body) => this.request.exec.bind(this.request, REQUESTS.ADD_AREA_PROPOSE,
                {
                    queryParams: Object.assign({}
                        , EXTRA_ENV[envTo.toUpperCase()]?.cgi ?? {}
                        , { comment: encodeURIComponent(comment) }),
                    body,
                    headers: { 'saasnew': HOST[envTo.toUpperCase()] },
                    removeExtraCgi: true,
                }),
            );

        const qs = new QueryScheduler({
            queue,
            limit: COUNT_FIRST,
            onProgress: onProgress.bind(this),
            onSuccess: onSuccess.bind(this),
        });

        qs.run();
    }

    descriptionGetter(el) {
        const description = el?.hard_tags?.reduce?.((_p, _c) => {
            _p += `${_c.tag}, `;

            return _p;
        }, '');
        if (!el?.area_title && !el?.area_tags && !el?.hard_tags?.length) {
            return null;
        }

        return `${el?.area_title ? `${el.area_title}; ` : ''}`
            + ` ${el?.area_tags ? `${el.area_tags}; ` : ''} `
            + `${description || ''}`;
    }

    render() {
        return <div className={_style.component}>
            <MoveEntity descriptionKey={'area_tags'}
                        result={this.state.result}
                        descriptionGetter={this.descriptionGetter.bind(this)}
                        getEntityList={this.getAreas.bind(this)}
                        moveEntities={this.moveAreas.bind(this)}
                        proposeEntities={this.proposeAreas.bind(this)}/>
        </div>;
    }
}
