import React from 'react';

import { EXTRA_ENV } from '../../../../types';
import { Request2 } from '../../../utils/request';
import QueryScheduler, { COUNT_FIRST } from '../../QueryScheduler/QueryScheduler';
import { HOST } from '../constants';
import MoveEntity from '../index';
import * as _style from '../index.css';
import { MIGRATE_REQUESTS, REQUESTS } from '../request';

interface IMoveTagsState {
    result: any;
}

export class MoveBots extends React.Component<IMoveTagsState> {
    state: IMoveTagsState = {
        result: [],
    };

    request = new Request2({ requestConfigs: MIGRATE_REQUESTS });

    async getBots(requestQueue: (queue: Promise<unknown>[]) => any) {
        const hostsKeys = Object.keys(HOST);
        const queue = hostsKeys.map((key) => (
            this.request.exec(REQUESTS.GET_BOTS, {
                headers: { 'saasnew': HOST[key.toUpperCase()] },
                queryParams: EXTRA_ENV[key.toUpperCase()]?.cgi ?? null,
                removeExtraCgi: true,
            })
        ));

        const response = await requestQueue(queue);
        const result = {};

        response?.forEach((host_res, index) => {
            host_res?.rt_backgrounds?.forEach((el) => {
                if (result.hasOwnProperty(el.bp_name)) {
                    result[el.bp_name][hostsKeys[index].toLowerCase()] = el;
                } else {
                    result[el.bp_name] = {
                        [hostsKeys[index].toLowerCase()]: el,
                    };
                }
            });
        });

        this.setState({
            result,
        });
    }

    descriptionGetter(el) {
        const description = el?.bp_settings?.bp_description || '';
        const type = el?.bp_type || el?.bp_revision;

        return `${description}${type ? ` (${type})` : ''}`;
    }

    moveBots(entities, envTo, onProgress, onSuccess) {
        const queue = entities
            .map(
                (body) => {
                    const options: any = {
                        body: { backgrounds: [body] },
                        headers: {
                            saasnew: HOST[envTo.toUpperCase()],
                        },
                        queryParams:  EXTRA_ENV[envTo.toUpperCase()]?.cgi ?? null,
                        removeExtraCgi: true,
                    };

                    return this.request.exec.bind(this.request, REQUESTS.ADD_BOTS, ...options);
                },
            );

        const qs = new QueryScheduler({
            queue,
            limit: COUNT_FIRST,
            onProgress: onProgress.bind(this),
            onSuccess: onSuccess.bind(this),
        });

        qs.run();
    }

    render() {
        return <div className={_style.component}>
            <MoveEntity descriptionKey={'bp_name'}
                        descriptionGetter={this.descriptionGetter.bind(this)}
                        result={this.state.result}
                        getEntityList={this.getBots.bind(this)}
                        moveEntities={this.moveBots.bind(this)}/>
        </div>;
    }
}
