import * as React from 'react';

import { EXTRA_ENV } from '../../../../types';
import { Request2 } from '../../../utils/request';
import QueryScheduler, { COUNT_FIRST } from '../../QueryScheduler/QueryScheduler';
import { HOST } from '../constants';
import MoveEntity from '../index';
import * as _style from '../index.css';
import { MIGRATE_REQUESTS, REQUESTS } from '../request';

interface IMoveRolesState {
    result: any;
}

export class MoveRoles extends React.Component<IMoveRolesState> {
    state: IMoveRolesState = {
        result: [],
    };

    request = new Request2({ requestConfigs: MIGRATE_REQUESTS });

    async getRoles(requestQueue: (queue: Promise<unknown>[]) => any) {
        const hostsKeys = Object.keys(HOST);
        const queue = hostsKeys.map((key) => (
            this.request.exec(REQUESTS.GET_ROLES, {
                headers: { 'saasnew': HOST[key.toUpperCase()] },
                queryParams: Object.assign({}, EXTRA_ENV[key.toUpperCase()]?.cgi ?? {}, { report: 'compact' }),
                removeExtraCgi: true,
            })
        ));

        const response = await requestQueue(queue);
        const result = {};

        response?.forEach((host_res, index) => {
            host_res?.report?.forEach((el) => {
                if (result.hasOwnProperty(el.role_id)) {
                    result[el.role_id][hostsKeys[index].toLowerCase()] = el;
                } else {
                    result[el.role_id] = {
                        [hostsKeys[index].toLowerCase()]: el,
                    };
                }
            });
        });

        this.setState({
            result,
        });
    }

    moveRole(entities, envTo, onProgress, onSuccess) {
        const queue = entities
            .map((body) => this.request.exec.bind(this.request, REQUESTS.ROLES_UPSERT,
                {
                    body: [body],
                    headers: { 'saasnew': HOST[envTo.toUpperCase()] },
                    queryParams: EXTRA_ENV[envTo.toUpperCase()]?.cgi ?? null,
                    removeExtraCgi: true,
                }),
            );

        const qs = new QueryScheduler({
            queue,
            limit: COUNT_FIRST,
            onProgress: onProgress.bind(this),
            onSuccess: onSuccess.bind(this),
        });

        qs.run();
    }

    proposeRole(entities, envTo, onProgress, onSuccess, comment) {
        const queue = entities
            .map((body) => this.request.exec.bind(this.request, REQUESTS.ROLES_PROPOSE,
                {
                    queryParams: {
                        comment: encodeURIComponent(comment),
                        backend_cluster: EXTRA_ENV[envTo.toUpperCase()]?.cgi ?? null,
                    },
                    body: [body],
                    headers: { 'saasnew': HOST[envTo.toUpperCase()] },
                    removeExtraCgi: true,
                }),
            );

        const qs = new QueryScheduler({
            queue,
            limit: COUNT_FIRST,
            onProgress: onProgress.bind(this),
            onSuccess: onSuccess.bind(this),
        });

        qs.run();
    }

    render() {
        return <div className={_style.component}>
            <MoveEntity descriptionKey={'role_description'}
                        result={this.state.result}
                        getEntityList={this.getRoles.bind(this)}
                        moveEntities={this.moveRole.bind(this)}
                        proposeEntities={this.proposeRole.bind(this)}/>
        </div>;
    }
}
