import { ENVIRONMENT, EXTRA_ENV } from '../../../types';
import { HOST as _HOST } from '../../constants';

export const HOST = {
    ADMIN: `https://${ENVIRONMENT.ADMIN}.${_HOST}`,
    PRESTABLE: `https://${ENVIRONMENT.PRESTABLE}.${_HOST}`,
    TESTING: `https://${ENVIRONMENT.TESTING}.${_HOST}`,
    QA: `https://${EXTRA_ENV.QA.env}.${_HOST}`,
    ST: `https://${EXTRA_ENV.ST.env}.${_HOST}`,
    ['LEASING-CABINET']: `https://${ENVIRONMENT['LEASING-CABINET']}.${_HOST}`,
    DM_PRESTABLE: `https://${EXTRA_ENV.DM_PRESTABLE.env}.${_HOST}`,
    DM_TEST: `https://${EXTRA_ENV.DM_TEST.env}.${_HOST}`,
};

export const MOVE_DIRECTION = {
    TESTING: ENVIRONMENT.TESTING,
    PRESTABLE: ENVIRONMENT.PRESTABLE,
    QA: ENVIRONMENT.QA,
    ST: ENVIRONMENT.ST,
    ['LEASING-CABINET']: ENVIRONMENT['LEASING-CABINET'],
    DM_PRESTABLE: ENVIRONMENT.DM_PRESTABLE,
    DM_TEST: ENVIRONMENT.DM_TEST,
};
