import { IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export enum REQUESTS {
    GET_TAGS = 'GET_TAGS',
    GET_BOTS = 'GET_BOTS',
    ADD_BOTS = 'ADD_BOTS',
    ADD_TAG = 'ADD_TAG',
    ADD_ACTION = 'ADD_ACTION',
    GET_ACTIONS = 'GET_ACTIONS',
    ADD_ACTION_PROPOSE = 'ADD_ACTION_PROPOSE',
    GET_ROLES = 'GET_ROLES',
    ROLES_PROPOSE = 'ROLES_PROPOSE',
    ROLES_UPSERT = 'ROLES_UPSERT',
    GET_NOTIFIERS = 'GET_NOTIFIERS',
    ADD_NOTIFIERS = 'ADD_NOTIFIERS',
    GET_AREAS = 'GET_AREAS',
    ADD_AREA = 'ADD_AREA',
    ADD_AREA_PROPOSE = 'ADD_AREA_PROPOSE'
}

export const MIGRATE_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_TAGS]: {
        api: 'tag/description/list',
        cgiObj: {
            backend_cluster: null,
        },
    },
    [REQUESTS.GET_BOTS]: {
        api: 'bg/info',
        cgiObj: {
            backend_cluster: null,
        },
    },
    [REQUESTS.ADD_BOTS]: {
        method: REQUEST_METHOD.POST,
        api: 'bg/upsert',
        cgiObj: {
            backend_cluster: null,
        },
    },
    [REQUESTS.GET_ACTIONS]: {
        api: 'actions/list',
        cgiObj: {
            backend_cluster: null,
            report: null, //compact
        },
    },
    [REQUESTS.ADD_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'tag/description/add',
        cgiObj: {
            backend_cluster: null,
        },
    },
    [REQUESTS.ADD_ACTION]: {
        method: REQUEST_METHOD.POST,
        api: 'actions/add',
        cgiObj: {
            backend_cluster: null,
        },
    },
    [REQUESTS.ADD_ACTION_PROPOSE]: {
        method: REQUEST_METHOD.POST,
        api: `actions/propose`,
        cgiObj: {
            comment: null,
            backend_cluster: null,
        },
    },
    [REQUESTS.GET_ROLES]: {
        api: 'roles/list',
        cgiObj: {
            backend_cluster: null,
            report: null,
            role_id: null,
        },
    },
    [REQUESTS.ROLES_UPSERT]: {
        method: REQUEST_METHOD.POST,
        api: 'roles/snapshot/upsert',
        cgiObj: {
            backend_cluster: null,
        },
    },
    [REQUESTS.ROLES_PROPOSE]: {
        method: REQUEST_METHOD.POST,
        api: 'roles/snapshot/propose',
        cgiObj: {
            comment: null,
            backend_cluster: null,
        },
    },
    [REQUESTS.GET_NOTIFIERS]: {
        api: 'notifiers/info',
        cgiObj: {
            backend_cluster: null,
        },
    },
    [REQUESTS.ADD_NOTIFIERS]: {
        api: 'notifiers/upsert',
        method: REQUEST_METHOD.POST,
        cgiObj: {
            backend_cluster: null,
        },
    },
    [REQUESTS.GET_AREAS]: {
        api: 'areas/info',
        cgiObj: {
            backend_cluster: null,
        },
    },
    [REQUESTS.ADD_AREA]: {
        api: 'areas/upsert',
        method: REQUEST_METHOD.POST,
        cgiObj: {
            backend_cluster: null,
        },
    },
    [REQUESTS.ADD_AREA_PROPOSE]: {
        api: '/areas/propositions/propose',
        method: REQUEST_METHOD.POST,
        cgiObj: {
            backend_cluster: null,
            comment: null,
        },
    },
};
