/*eslint-disable no-magic-numbers*/
import React from 'react';
import ReactDOMServer from 'react-dom/server';

declare let ymaps: any;

const rectOptions = {
    fillColor: '#7df9ff33',
    fillOpacity: 0.4,
    strokeColor: '#0000FF',
    strokeOpacity: 0.5,
    strokeWidth: 2,
    strokeStyle: '2 6',
};
const rectProps = {
    hintContent: 'Полигон поска доступных авто',
};

export default function drawAvailableCars({ availableCars, availableCarsCollection }) {
    availableCarsCollection?.removeAll();

    if (ymaps && availableCars?.bbox) {
        const rect = ymaps?.Rectangle;

        const myRectangle = rect && new rect(availableCars.bbox, rectProps, rectOptions);
        availableCarsCollection?.add(myRectangle);
    }

    if (ymaps && availableCars?.cars?.length) {
        availableCars?.cars.forEach(car => {
            availableCarsCollection?.add(addCar(car, availableCars));
        });
    }
}

const addCar = (car, availableCars) => {
    const placemark = new ymaps.Placemark(
        [car?.location?.lon, car?.location?.lat],
        {},
        {
            iconCaption: `${car?.number}: ${availableCars?.models[car?.model_id]?.name}`,
            hideIconOnBalloonOpen: false,
            iconLayout: 'default#imageWithContent',
            cursor: 'pointer',
            iconImageSize: [20, 40],
            iconImageOffset: [-10, -20],
            iconImageHref: '',
            iconContentLayout: iconContentLayout(car, availableCars),
            hintLayout: hintLayout(car, availableCars),
        });

    placemark.events.add('click', () => {
        window.open(`#/cars/${car.id}/info`);
    });

    return placemark;
};

const iconContentLayout = (car, availableCars) => {
    return ymaps.templateLayoutFactory
        .createClass(ReactDOMServer.renderToString(<CarPin car={car} availableCars={availableCars}/>));
};

const hintLayout = (car, availableCars) => {
    return ymaps.templateLayoutFactory
        .createClass(ReactDOMServer.renderToString(<CarTooltip car={car} availableCars={availableCars}/>));
};

const CarPin = ({ availableCars, car }) => {
    const DEG_180 = 180;
    const angle = `${(+car?.location?.course || 0) + DEG_180}deg`;
    const model = availableCars?.models[car?.model_id];

    return <div style={
        {
            backgroundImage: `url(${model?.image_map_url_2x})`,
            backgroundSize: 'cover',
            backgroundRepeat: 'no-repeat',
            width: '20px',
            height: '40px',
            transform: `rotate(${angle})`,
            transformOrigin: '50% 50%',
        }
    }>
    </div>;
};

const CarTooltip = ({ availableCars, car }) => {
    const model = availableCars?.models[car?.model_id];

    return <div style={
        {
            minWidth: '180px',
            minHeight: '50px',
            padding: '5px',
            borderRadius: '6px',
            backgroundColor: '#fff',
            fontSize: '14px',
            boxShadow: '0px 0px 25px -15px #000',
            border: '1px solid #dadada',
        }
    }>
        <div>модель: <strong>{model.name}</strong></div>
        <div>номер: <strong>{car.number}</strong></div>
        <div>топливо: <strong>{car?.telematics?.fuel_level}%</strong></div>
    </div>;
};
