import { connect } from 'react-redux';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../constants';
import { getRawSetting } from '../../utils/getRawSetting';
import { IStore } from '../App/store';
import { polyFiltersKey } from '../InterfaceAdminConfig/adminConfigKeys';
import { MiniMap } from './component';

const POLY_FILTERS_KEY = `${GVARS_INTERFACE_ADMIN_PREFIX}.${polyFiltersKey}`;
const POLY_CONFIG_KEY = 'interface_admin.polyConfig';

export const mapStateToProps = (store: IStore ) => {
    const polyFilters = getRawSetting(store, POLY_FILTERS_KEY);
    const polyConfig = getRawSetting(store, POLY_CONFIG_KEY);

    return {
        polyFilters,
        polyConfig,
        BlockRules: store?.AdminUser?.blockRules,
    };
};

export default connect(mapStateToProps)(MiniMap);
