import React from 'react';

import { Dict } from '../../../../types';
import { ONE_SECOND } from '../../../constants';
import FormatDate from '../../../ui/FormatDate';
import { Link } from '../../../ui/Link';
import Img from '../../Img';
import style from './index.css';

export interface IPhotoItem {
    created_at: number;
    dups: IPhotoItem[];
    image_id: number;
    mark_up_list: Dict<any>[];
    marker: string;
    meta_data: null | Dict<any>;
    object_id: string;
    object_type: string;
    origin: any;
    path: string;
    preview_path: string;
    preview_url: string;
    source: string;
    url: string;
    user_session_id: string;
}

interface IPhotoItemProps {
    photo: IPhotoItem;
    index: number;
    children?: any;
}

export const SessionLink = (props: { session_id: string }) => {
    return <Link href={`#/session/${props.session_id}/billing?back=${encodeURIComponent(location.hash)}`}
                 target={'_blank'}>Сессия</Link>;
};

export const PhotoItem = (props: IPhotoItemProps) => {
    const { photo, index, children } = props;

    return <div className={`${style.photo_item}`}>
        <div className={`${style.photo_item_img}`}>
            <Img src={photo.preview_url || photo.url} customDataIndex={index}/>
        </div>
        <div className={`${style.photo_item_info}`}>
            {
                children
                    ? <>
                        {children}
                    </>
                    : <>
                        <div className={style.bottom_description}>
                            <FormatDate value={photo.created_at * ONE_SECOND} withSecond/>
                            <SessionLink session_id={photo.user_session_id}/>
                        </div>
                    </>
            }
        </div>
    </div>;
};
