import React, { useState } from 'react';

import { Button, ButtonTypes } from '../../../ui/Button';
import { Confirm } from '../../../ui/FullModal';
import { Request2 } from '../../../utils/request';
import { requestConfigs, REQUESTS } from '../request';
import style from './index.css';

interface IPhotoItem {
    image_id: number;
    id: string;
    title: string;
}

export const DeletePhotoControl = React.memo((props: { photo: IPhotoItem }) => {
    const { image_id, id, title } = props.photo;

    const [isConfirmOpened, openConfirm] = useState<boolean>(false);
    const [isLoading, setIsLoading] = useState<boolean>(false);
    const [error, setError] = useState<Error | null>(null);

    function deletePhoto() {
        const request = new Request2({ requestConfigs });
        setIsLoading(true);

        request.exec(REQUESTS.DELETE_PHOTO, {
            body: {
                image_id,
                description: id,
            },
        })
            .then(() => {
                setError(null);
                setIsLoading(false);
                openConfirm(false);
            })
            .catch(error => {
                setError(error);
                setIsLoading(false);
            });
    }

    return <>
        <div className={style.info}>
            <div><b>{title}</b></div>
            <div><b>ID фото: </b>{image_id}</div>
        </div>

        <Button onClick={openConfirm.bind(null, true)}
                colorType={ButtonTypes.negative}
                className={style.delete_photo}
                isLoading={isLoading}
                basic={true}>
            Удалить повреждение
        </Button>

        {isConfirmOpened
            ? <Confirm error={error}
                       question={'Удалить невалидное повреждение?'}
                       isWorking={isLoading}
                       onClose={openConfirm.bind(null, false)}
                       accept={deletePhoto.bind(null)}/>
            : null
        }
    </>;
});
