import React from 'react';

import { EMPTY_DATA, ONE_SECOND } from '../../../constants';
import { useDamagesConfig } from '../../../hooks/useDamagesConfig';
import FormatDate from '../../../ui/FormatDate';
import { IsChecked } from '../../../ui/IsChecked';
import { Link } from '../../../ui/Link';
import { getDamageLevel, getDescription, Verdicts } from '../../ChatOutgoing/ChatWindow/DamagesPhotos/constants';
import Img from '../../Img';
import { PictureGallery } from '../../PictureGallery';
import { IPhotoItem, SessionLink } from '../PhotoItem';
import style from './index.css';

interface PictureGalleryControlItemProps {
    photo: IPhotoItem;
}

export const PictureGalleryControlItem = (props: PictureGalleryControlItemProps) => {
    const { photo } = props;
    const [, configs] = useDamagesConfig();

    const [selectedDupsPhotoIndex, selectPhoto] = React.useState(null);
    const showDubsGallery = (selectedDupsPhotoIndex, e) => {
        e?.stopPropagation();
        selectPhoto(selectedDupsPhotoIndex);
    };

    const dupsImages = photo.dups?.map(img => ({ src: img.url, link: img.url }));

    return <div className={`${style.controls}`}>
        <div><strong>id: </strong> {photo.image_id}</div>
        <div><strong>дата: </strong><FormatDate value={photo.created_at * ONE_SECOND} withSecond/></div>
        <div><strong>объект: </strong> {photo.object_type}</div>
        <div><strong>источник: </strong> {photo.source}</div>
        {photo.source !== 'feedback' && <div><strong>маркер: </strong> {photo.marker}</div>}
        <div><strong>дублей: </strong> {photo.dups?.length ?? EMPTY_DATA}</div>
        <div><SessionLink session_id={photo.user_session_id}/></div>
        <br/>
        <div><strong>Повреждения:</strong></div>
        {
            photo.mark_up_list?.length
                ? photo.mark_up_list.map((el, index) => {
                    return <div key={index}>
                        - {el?.is_the_best && <IsChecked checked={el?.is_the_best} className={style.inline}/>}
                        {getDamageLevel(configs, el)}
                        <div className={style.description}> {getDescription(configs, el)}</div>
                    </div>;
                })
                : <div>{EMPTY_DATA}</div>
        }
        <div><strong>Разметка:</strong></div>
        <div>
            <FormatDate value={photo.meta_data?.support_verdicts_timestamp} withSecond/>
        </div>
        {
            photo.meta_data?.support_verdicts?.map((el, index) => {
                return <div key={index}>
                    {index + 1}) {Verdicts[el.verdict]} {
                        el.st_link && <Link href={el.st_link} target={'_blank'}>трекер</Link>}
                </div>;
            })
        }

        <div>
            <h4>фото дублей:</h4>
            <div className={style.dups_photo_container}>
                {
                    photo?.dups?.map((el, index) => {
                        return <div key={index} onClick={showDubsGallery.bind(null, index)}>
                            <Img src={el.preview_url || el.url}
                                 className={`${style.dups_item_photo}`}/>
                        </div>;
                    })
                }
            </div>
            {
                selectedDupsPhotoIndex !== null && <PictureGallery onClose={showDubsGallery.bind(null, null)}
                                                                   pictures={dupsImages}
                                                                   initialIndex={selectedDupsPhotoIndex || 0}/>
            }
        </div>
    </div>;
};
