import { IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export enum REQUESTS {
    GET_PHOTOS = 'GET_PHOTOS',
    DELETE_PHOTO = 'DELETE_PHOTO',
}

export const requestConfigs: IComponentRequest = {
    [REQUESTS.GET_PHOTOS]: {
        api: 'photo/markup/get',
        cgiObj: {
            session_id: null,
            car_id: null,
            since: null,
            until: null,
            source: null,
            report_validated: null, //DRIVEFRONT-1472
            report_dups: true, //https://st.yandex-team.ru/DRIVEBACK-2794
        },
    },
    [REQUESTS.DELETE_PHOTO]: {
        method: REQUEST_METHOD.POST,
        api: 'photo/markup/invalidate',
    },
};
