export const COUNT_FIRST = 8;

export interface IProgressData {
    queue: any[];
    success: any[];
    failed: any[];
}

interface IProps {
    queue: any[];
    limit: number;
    onProgress: (data: IProgressData) => void;
    onSuccess: (data: IProgressData) => void;
}

export default class QueryScheduler {
    _queue: any[] = [];
    _limit = 1;
    _onProgress: Function | null = null;
    _onSuccess: Function | null = null;
    _failed: any[] = [];
    _success: any[] = [];
    _curIndex = 0;

    constructor(props: IProps) {
        this._queue = props.queue;
        this._limit = props.limit > props.queue.length ? props.queue.length : props.limit;
        this._onProgress = props.onProgress;
        this._onSuccess = props.onSuccess;
    }

    run() {
        for (let i = 0; i <= this._limit; i++) {
            this._curIndex++;
            this.runOne.bind(this, i)();
        }
    }

    runOne(item: number) {
        return this._queue[item] && this._queue[item]()
            .then(this.callback.bind(this))
            .catch(this.catchCallback.bind(this, item));
    }

    callback(data: any) {
        this._success.push(data);
        this.next();
    }

    next() {
        this._onProgress && this._onProgress(this.getProgress());
        if (this._curIndex <= this._queue.length - 1) {
            this.runOne(this._curIndex++);
        }

        if (this._success.length + this._failed.length === this._queue.length) {
            this._onSuccess && this._onSuccess(this.getProgress());
        }
    }

    getProgress() {
        return { failed: this._failed, success: this._success, queue: this._queue };
    }

    catchCallback(data: any, error: any) {
        this._failed.push({ data, error });
        this.next();
    }
}
