import * as React from 'react';

import { TIMERS } from '../../constants';
import { Request2 } from '../../utils/request';
import { SimpleError } from '../SimpleError';
import { P_REQUESTS, REQUESTS } from './request';

interface IRedirectByPhoneProps {
    number: string;
}

interface IRedirectByPhoneState {
    error: null | Error;
}

const ACTIVE_USER_STATUS = 'active';
const LIMIT = 100;

export default class RedirectByPhone extends React.Component<IRedirectByPhoneProps, IRedirectByPhoneState> {
    request = new Request2({ requestConfigs: P_REQUESTS });
    state: IRedirectByPhoneState = {
        error: null,
    };
    interval: any;

    getHash(id) {
        location.hash = `#/clients/${id}/info`;
    }

    componentDidMount(): void {
        const searchText = this.props?.number?.toString().replace(/[\+|\s|-]/ig, '');
        this.request.exec(REQUESTS.FIND, {
            queryParams: {
                has_all_of: searchText,
                limit: LIMIT,
            },
        })
            .then((response) => {
                const users = response?.objects?.users || [];
                const activeUser = users.filter((user: any) => user.status === ACTIVE_USER_STATUS) || [];

                if (activeUser.length) {
                    this.getHash(activeUser[0]?.id);
                } else if (users.length) {
                    this.getHash(users[0]?.id);
                } else {
                    this.setState({
                        error: new Error('Не найден пользователь!'),
                    }, () => {
                        this.interval = setTimeout(() => {
                            location.hash = `#/`;
                        }, TIMERS.UPDATE_SELECTED);
                    });
                }
            })
            .catch((error) => {
                this.setState({
                    error,
                });
            });
    }

    componentWillUnmount(): void {
        this.request.abort();
        clearTimeout(this.interval);
    }

    render() {
        return <>
            <h2>Поиск телефона: {this.props.number}</h2>
            {this.state.error ? <SimpleError error={this.state.error}/> : null}
        </>;
    }
}
