import React from 'react';
import { withRouter } from 'react-router-dom';

import { useTagsData } from '../../../hooks/useTagsData';
import { Button } from '../../../ui/Button';
import { Window } from '../../../ui/FullModal';
import { isObjectEqual } from '../../../utils/isObjectEqual';
import { Request2 } from '../../../utils/request';
import { FormConstructor } from '../../FormConstructor';
import { controlType } from '../../FormConstructor/types';
import { requestConfigs, REQUESTS } from './request';

export class _GroupActions extends React.Component<any, any> {
    state = {
        isOpen: false,
        isLoading: false,
        error: null,
        data: {},
    };
    tags = new Set();
    request = new Request2({ requestConfigs });

    setOpen(isOpen) {
        this.setState({
            isOpen,
            isLoading: false,
            error: null,
        });
    }

    onChange(data) {
        this.setState({
            data,
        });
    }

    componentDidMount() {
        this.compileTags();
    }

    componentDidUpdate(prevProps: Readonly<any>, prevState: Readonly<any>, snapshot?: any) {
        if (!isObjectEqual(prevProps.flowItem, this.props.flowItem)) {
            this.compileTags();
        }
    }

    compileTags() {
        this.tags.clear();
        Object.entries(this.props?.flowItem)?.forEach?.(([, el]: [any, any]) => {
            el?.actions?.forEach(_ => {
                _.mainButton && this.tags.add(_.tagName);
            });
        });
    }

    onAction() {
        const actions = Object.entries(this.state.data)?.filter((el => el[1])).map(el => el[0]) || [];
        const object_id = this.props?.match?.params?.client_id;
        object_id && actions.length && this.setState({
            isLoading: true,
        }, () => {
            this.request.exec(REQUESTS.ADD_TAG, {
                body: {
                    object_id,
                    add_tags: actions.map(tag => {
                        return {
                            priority: 0,
                            tag,
                        };
                    }),
                },
            }).then(() => {
                this.setState({
                    isLoading: false,
                    isOpen: false,
                    error: null,
                });
            }).catch(error => {
                this.setState({
                    isLoading: false,
                    error,
                });
            });
        });
    }

    componentWillUnmount() {
        this.request.abort();
    }

    render() {
        const { uniqueTag } = this.props;
        const { isOpen, error, isLoading } = this.state;

        return <div>
            <Button onClick={this.setOpen.bind(this, true)}>
                ↑ Перезапрос {uniqueTag ? `(${uniqueTag})` : ''}
            </Button>

            {isOpen
                ? <GroupActionsModal error={error}
                                     isLoading={isLoading}
                                     onChange={this.onChange.bind(this)}
                                     onAction={this.onAction.bind(this)}
                                     onClose={this.setOpen.bind(this, false)}
                                     tags={[...this.tags]}/>
                : null
            }
        </div>;
    }
}

export const GroupActions = withRouter(_GroupActions);

const GroupActionsModal = (props) => {
    const [isLoading, tags] = useTagsData();

    const schema = props.tags?.reduce((_p, _c) => {
        _p[_c] = {
            type: controlType.bool,
            display_name: tags?.[_c]?.display_name || _c,
            description: tags?.[_c]?.comment,
        };

        return _p;
    }, {});

    return <Window title={'Групповой перезапрос'} onClose={props.onClose} error={props.error}>
        <FormConstructor onChange={props.onChange}
                         schema={schema}/>
        <div>
            <Button isLoading={props.isLoading} onClick={props.onAction}>Запросить</Button>
        </div>
        <div>{isLoading ? 'загрузка "человеческих" названий...' : ''}</div>
    </Window>;
};
