import * as React from 'react';

import { ISessionBill } from '../../models/session';
import { rubs } from '../../utils/rubs';
import * as styles from './index.css';

const BILL_TYPE_BONUS = 'billing_bonus';

export const SessionBill = (props: { bill: ISessionBill[] }) => {
    const { bill } = props;

    return bill
        ? <table className={`${styles.bill_table}`}>
            <tbody>
                {bill.map((item: any, index: number) => {
                    return (
                        <tr key={index}>
                            <td title={item.type}>
                                <strong>{item.title}:</strong>
                            </td>
                            <td>{item.type !== BILL_TYPE_BONUS ? item.details : ''}</td>
                            <td className={styles.money}>{rubs(item.cost)}</td>
                        </tr>
                    );
                })}
            </tbody>
        </table>
        : null;
};
