import React from 'react';

import Photos from '../Photos';
import { SessionCardTimeline } from './SessionCardTimeline';
import SessionTagList from './SessionTagList';

interface ISessionAcceptancePhotosProps {
    sessionId: string;
}

const SessionCardAcceptancePhotos = (props: ISessionAcceptancePhotosProps) => {
    const { sessionId } = props;

    return <>
        <SessionCardTimeline/>
        <SessionTagList sessionId={sessionId}/>
        <Photos session_id={sessionId}/>
    </>;
};

export default SessionCardAcceptancePhotos;
