import React from 'react';

import { ONE_SECOND } from '../../constants';
import { useRequestHandler } from '../../hooks/useRequestHandler';
import { SessionHistoryInfoHandler } from '../../models/session';
import FormatDate from '../../ui/FormatDate';
import { Link } from '../../ui/Link';
import { NoInformation } from '../../ui/NoInformation';
import * as styleTable from '../../ui/Table/index.css';
import { Request2 } from '../../utils/request';
import { SimpleError } from '../SimpleError';
import Spin from '../Spin';
import { SessionContext } from './component';
import { REQUESTS, SESSION_REQUESTS } from './request';

const match_tag = 'fueling_';
const full_tag = 'full_tank_marker';

const SessionCardFueling = () => {
    const context = React.useContext(SessionContext);
    const car_id = SessionHistoryInfoHandler.getCarId.call(context);
    const since = SessionHistoryInfoHandler.getStart.call(context);
    const until = SessionHistoryInfoHandler.getFinish.call(context);
    const request = new Request2({ requestConfigs: SESSION_REQUESTS });

    const options = React.useMemo(() => {
        return {
            requestName: REQUESTS.GET_CAR_TAGS_HISTORY,
            requestOptions: {
                queryParams: {
                    car_id,
                    since: since && Math.floor(since / ONE_SECOND),
                    until: until && Math.floor(until / ONE_SECOND),
                },
            },
        };
    }, [car_id]);

    const [isLoading, response, error, getRecords] = useRequestHandler<any>(request, options);

    React.useEffect(() => {
        getRecords();
    }, []);

    const records = response?.records?.filter?.(el => {
        return el.tag_name.includes(match_tag) || el.tag_name === full_tag;
    }) || [];

    return <div>
        {error && <SimpleError error={error}/>}
        {isLoading
            ? <Spin/>
            : records.length
                ? <table className={styleTable.table}>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>дата</th>
                            <th>тег</th>
                            <th>пользователь</th>
                            <th/>
                        </tr>
                    </thead>
                    <tbody>
                        {
                            records.map((el, index) => {
                                return <tr key={index}>
                                    <td>{index + 1}</td>
                                    <td><FormatDate value={el.timestamp * ONE_SECOND}/></td>
                                    <td>
                                        <div><b>{el.tag_display_name}</b></div>
                                        <div>{el.action}</div>
                                    </td>
                                    <td>
                                        {el?.user_data_full.username
                                    && <Link href={`#/clients/${el.user_id}/tags-history`}
                                             title={el.user_id}
                                             target={'_blank'}>
                                        {el?.user_data_full.username}
                                    </Link>

                                        }
                                        <div>
                                            {el.user_data_full
                                        && [el.user_data_full.last_name
                                        || '', el.user_data_full.first_name || ''].join(' ')}
                                        </div>
                                    </td>
                                    <td><Link href={`#/cars/${car_id}/tags/tag-history-details/${el.event_id}`}
                                              target={'_blank'}>detail</Link>
                                    </td>
                                </tr>;
                            })
                        }
                    </tbody>
                </table>
                : <NoInformation/>
        }

    </div>;
};

export default SessionCardFueling;
