import React from 'react';

import { ONE_SECOND } from '../../constants';
import { InsuranceNotification, SessionHistoryInfoHandler } from '../../models/session';
import FormatDate from '../../ui/FormatDate';
import { NoInformation } from '../../ui/NoInformation';
import * as styleTable from '../../ui/Table/index.css';
import { SessionContext } from './component';

const SessionCardInsurance = () => {
    const context = React.useContext(SessionContext);
    const records: InsuranceNotification[] = SessionHistoryInfoHandler.getInsuranceNotifications.call(context);

    return <div>
        {records.length
            ? <table className={styleTable.table}>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>id</th>
                        <th>формирование интервала (created)</th>
                        <th>конец интервала (finish)</th>
                        <th>начало интервала (start)</th>
                        <th>отсылка в страховую (sent)</th>
                        <th/>
                    </tr>
                </thead>
                <tbody>
                    {
                        records.map((el, index) => {
                            return <tr key={index}>
                                <td>{index + 1}</td>
                                <td>{el.id}</td>
                                <td><FormatDate value={el.created * ONE_SECOND} withSecond/></td>
                                <td><FormatDate value={el.finish * ONE_SECOND} withSecond/></td>
                                <td><FormatDate value={el.start * ONE_SECOND} withSecond/></td>
                                <td><FormatDate value={el.sent * ONE_SECOND} withSecond/></td>
                            </tr>;
                        })
                    }
                </tbody>
            </table>
            : <NoInformation/>
        }

    </div>;
};

export default SessionCardInsurance;
