import React from 'react';

import { ONE_SECOND } from '../../constants';
import { SessionHistoryInfoHandler } from '../../models/session';
import FormatDate from '../../ui/FormatDate';
import { NoInformation } from '../../ui/NoInformation';
import * as styleTable from '../../ui/Table/index.css';
import { SessionContext } from './component';

interface IRecord {
    start: number;
    finish: number;
    mileage: number;
}

const SessionCardService = () => {
    const context = React.useContext(SessionContext);
    const records: IRecord[] = SessionHistoryInfoHandler.getServiceItems
        .call(context).sort((a, b) => b.start - a.start);

    return <div>
        {records.length
            ? <table className={styleTable.table}>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>начало участка</th>
                        <th>конец участка</th>
                        <th>пробег</th>
                        <th/>
                    </tr>
                </thead>
                <tbody>
                    {
                        records.map((el, index) => {
                            return <tr key={index}>
                                <td>{index + 1}</td>
                                <td><FormatDate value={el.start / ONE_SECOND} withSecond/></td>
                                <td><FormatDate value={el.finish / ONE_SECOND} withSecond/></td>
                                <td>{el.mileage}</td>
                            </tr>;
                        })
                    }
                </tbody>
            </table>
            : <NoInformation/>
        }

    </div>;
};

export default SessionCardService;
