import * as React from 'react';
import { connect } from 'react-redux';

import { LONGTERM_MARK } from '../../constants';
import SessionsHistoryItem, { SessionHistoryInfoHandler } from '../../models/session';
import { UserInfoHandler } from '../../models/user';
import { Button, ButtonTypes } from '../../ui/Button';
import { Confirm } from '../../ui/FullModal';
import { JsonModal } from '../../ui/FullModal/JsonModal';
import { Link } from '../../ui/Link';
import { IBlockRules } from '../../utils/IBlockRules';
import LS from '../../utils/localStorage/localStorage';
import { buttonLocationDetails, buttonNameDetails } from '../../utils/sendLogs/eventTypes/buttonDetails';
import { openNewTab } from '../../utils/utils';
import { IStore } from '../App/store';
import { BonusControlDialog } from '../BonusControlDialog';
import { ManageDevices } from '../Clients/DocumentsView/component';
import CreateChatWindow from '../CreateChatWindow';
import { CHAT_TYPE } from '../CreateChatWindow/types';
import DocForQueuePicker from '../Documents/DocForQueuePicker';
import IncidentForm from '../IncidentForm';
import { UnplannedFinishDialog } from '../Longterm/UnplannedFinishDialog';
import TagModal from '../TagModal';
import { OBJECT_TYPES } from '../TagModal/component';
import * as styles from './index.css';
import { BillingCalculatorButton } from './modals/BillingCalculatorButton/component';
import { EvacuationForm } from './modals/EvacuationForm';
import { FineDialog } from './modals/FineDialog';
import { FixCompensateModal } from './modals/FixCompensateModal';
import { ViolationsForm } from './modals/ViolationsForm';
import { SessionBill } from './SessionBill';
import { SessionOffer } from './SessionOffer';

interface ISessionCardSidebarProps extends IBlockRules {
    session: SessionsHistoryItem;
}

const SessionCardSidebar = (props: ISessionCardSidebarProps) => {
    const { session, BlockRules } = props;
    const bill = SessionHistoryInfoHandler.getBill.call(session);
    const current_offer = SessionHistoryInfoHandler.getCurrentOffer.call(session);
    const offer_proto = SessionHistoryInfoHandler.getOffer.call(session) || {};
    const total = SessionHistoryInfoHandler.getTotalPrice.call(session);

    const [showBonusDialog, setBonusDialog] = React.useState(false);
    const [showDevicesDialog, setDevicesDialog] = React.useState(false);
    const [showEvacuationDialog, setEvacuationDialog] = React.useState(false);
    const [showViolationsDialog, setViolationsDialog] = React.useState(false);
    const [showTagDialog, setTagDialog] = React.useState(false);
    const [showSessionTagDialog, setSessionTagDialog] = React.useState(false);
    const [showAddChatDialog, setAddChatDialog] = React.useState(false);
    const [showProtoDialog, setProtoDialog] = React.useState(false);
    const [showIncidentNewDialog, setIncidentNewDialog] = React.useState(false);
    const [showFine, setFineDialog] = React.useState(false);
    const [showDocModal, setDocModal] = React.useState(false);
    const [showConfirm, setConfirm] = React.useState(false);
    const [showFixCompensate, setFixCompensate] = React.useState(false);
    const [showLongtermDialog, setLongtermDialog] = React.useState(false);
    const [isAddModalOpen, setAddModalOpen] = React.useState(false);

    const setVisibility = (value: boolean, set: (value: boolean) => void) => {
        set(!value);
    };

    const car = SessionHistoryInfoHandler.getCar.call(session);
    const carNumber = SessionHistoryInfoHandler.getCarNumber.call(session);
    const userId = SessionHistoryInfoHandler.getUserId.call(session);
    const carId = SessionHistoryInfoHandler.getCarId.call(session);
    const sessionId = SessionHistoryInfoHandler.getSessionId.call(session);
    const rideFinish = SessionHistoryInfoHandler.getFinish.call(session);
    const currentDevice = SessionHistoryInfoHandler.getOffer.call(session)?.DeviceIdAccept;
    const isEmptySession = SessionHistoryInfoHandler.getCount.call(session) === 0;

    const evacInitialData = {
        car_id: carId,
        user_id: userId,
        session_id: sessionId,
    };

    const finesForm = () => {
        const { session } = props;
        const userName = UserInfoHandler.getPrintNameWithoutUserName
            .call(SessionHistoryInfoHandler.getUserDetails.call(session));
        const clientUrl = userId ? `${location.origin}${location.pathname}#/clients/${userId}/info` : '';
        const autoUrl = carId ? `${location.origin}${location.pathname}#/cars/${carId}/info` : '';
        const rideUrl = sessionId ? `${location.origin}${location.pathname}#/session/${sessionId}` : '';
        const carNumber = SessionHistoryInfoHandler.getCarNumber.call(session);

        openNewTab(`https://forms.yandex-team.ru/surveys/24365/`
            + `?name=${encodeURIComponent(userName)}`
            + `&client_url=${encodeURIComponent(clientUrl)}`
            + `&auto_id=${encodeURIComponent(carNumber)}`
            + `&auto_url=${encodeURIComponent(autoUrl)}`
            + `&ride_url=${encodeURIComponent(rideUrl)}`
            + `&ride_end_date=${encodeURIComponent(rideFinish)}`
            + `&user_id=${encodeURIComponent(userId)}`,
        );
    };

    const ls = new LS();

    const initialDataIncidentForm = {
        session_id: sessionId,
        car_id: carId,
        user_id: userId,
    };

    const showFixCompensateButton = SessionHistoryInfoHandler.isFixOffer.call(session)
        && SessionHistoryInfoHandler.isSessionFinished.call(session)
        && BlockRules?.FixCompensate;

    const isLongtermSession = offer_proto?.InstanceType === LONGTERM_MARK;

    return (
        <>
            {
                showConfirm && <Confirm question={<>
                    <Link target={'_blank'}
                          href={`${location.origin}${location.pathname}#/chats`
                              + `?user_id=${userId}&chat_id=${showConfirm}`}>
                            ссылка на чат
                    </Link>
                </>}
                                        error={null}
                                        onClose={setVisibility.bind(null, showConfirm, setConfirm)}
                                        accept={setVisibility.bind(null, showConfirm, setConfirm)}/>
            }
            {showTagDialog && (
                <TagModal objectId={{ type: OBJECT_TYPES.USER, id: userId }}
                          initialData={{ session_id: sessionId, car_number: carNumber }}
                          session={session}
                          onClose={setVisibility.bind(null, showTagDialog, setTagDialog)}/>
            )} {showSessionTagDialog && (
                <TagModal objectId={{ type: OBJECT_TYPES.TRACE, id: sessionId }}
                          initialData={{
                              value: 0.9,
                              tag: 'scoring_trace_tag',
                          }}
                          onClose={setVisibility.bind(null, showSessionTagDialog, setSessionTagDialog)}/>
            )}
            {showFixCompensate && (
                <FixCompensateModal onClose={setVisibility.bind(null, showFixCompensate, setFixCompensate)}
                                    bill={bill}
                                    offerProto={offer_proto}
                                    userId={userId}
                                    carNumber={carNumber}
                                    sessionId={sessionId}/>
            )}
            {showAddChatDialog && (
                <CreateChatWindow type={CHAT_TYPE.chats}
                                  object_id={userId}
                                  link={`${location.origin}${location.pathname}#/session/${sessionId}`}
                                  onClose={setVisibility.bind(null, showAddChatDialog, setAddChatDialog)}/>
            )}
            {showViolationsDialog && (
                <ViolationsForm sessionId={sessionId}
                                userId={userId}
                                onClose={setVisibility.bind(null, showViolationsDialog, setViolationsDialog)}/>
            )}
            {showDevicesDialog && (
                <ManageDevices onClose={setVisibility.bind(null, showDevicesDialog, setDevicesDialog)}
                               currentDevice={currentDevice}
                               user_id={userId}/>
            )}
            {showBonusDialog && (
                <BonusControlDialog onClose={setVisibility.bind(null, showBonusDialog, setBonusDialog)}
                                    userId={userId}
                                    sessionId={sessionId}/>
            )}
            {showEvacuationDialog && (
                <EvacuationForm onClose={setVisibility.bind(null, showEvacuationDialog, setEvacuationDialog)}
                                initialData={evacInitialData}/>
            )}
            {showProtoDialog && (
                <JsonModal onClose={setVisibility.bind(null, showProtoDialog, setProtoDialog)}
                           obj={offer_proto}
                           title={`offer_proto`}/>
            )}
            {showDocModal && (
                <DocForQueuePicker initValues={{
                    car_id: carId, user_id: userId, session_id: sessionId,
                    comment: car
                            && car
                            && car.number || '',
                }}
                                   onClose={setVisibility.bind(null, showDocModal, setDocModal)}/>
            )}

            {
                showFine ? <FineDialog onClose={setFineDialog.bind(null, false)}
                                       session_id={sessionId}
                                       user_id={userId}
                                       car_id={carId}/>
                    : null
            }
            {showIncidentNewDialog
                ? <IncidentForm initialData={initialDataIncidentForm}
                                onClose={setVisibility.bind(null, showIncidentNewDialog, setIncidentNewDialog)}/>
                : null}

            {showLongtermDialog
                ? <UnplannedFinishDialog session={session}
                                         onClose={setLongtermDialog.bind(null, false)}/>
                : null
            }

            {isAddModalOpen
                ? <TagModal objectId={{ type: OBJECT_TYPES.CAR, id: carId }}
                            initialData={{ session_id: sessionId }}
                            onClose={setAddModalOpen.bind(null, false)}/>
                : null
            }

            <div className={styles.sidebar}>
                <SessionBill bill={bill}/>
                <SessionOffer BlockRules={BlockRules}
                              isSessionCard
                              current_offer={current_offer}
                              offer_proto={offer_proto}
                              session={session}
                              total={total}/>
                {!isEmptySession &&
                <div className={styles.button_container}>
                    <div className={styles.button_group}>
                        {
                            BlockRules?.NewIncidentForm
                                ? <Button colorType={ButtonTypes.negative}
                                          ytLog={{
                                              button_name: buttonNameDetails.INCIDENT_NEW,
                                              location: buttonLocationDetails.SESSION_CARD,
                                          }}
                                          onClick={setVisibility
                                              .bind(null, showIncidentNewDialog, setIncidentNewDialog)}>
                                    Инцидент
                                </Button>
                                : null
                        }
                        <Button className={styles.button}
                                onClick={setVisibility.bind(null, showDocModal, setDocModal)}
                                colorType={ButtonTypes.warning}
                                ytLog={{
                                    button_name: buttonNameDetails.SHOW_DOCUMENTS,
                                    location: buttonLocationDetails.SESSION_CARD,
                                }}>Документы</Button>
                        {props.BlockRules && <BillingCalculatorButton location={buttonLocationDetails.SESSION_CARD}
                                                                      className={styles.button}
                                                                      session={session}
                                                                      BlockRules={props.BlockRules}>
                            Калькулятор
                        </BillingCalculatorButton>}
                        <Button className={styles.button}
                                onClick={setVisibility.bind(null, showViolationsDialog, setViolationsDialog)}
                                colorType={ButtonTypes.warning}
                                ytLog={{
                                    button_name: buttonNameDetails.VIOLATION,
                                    location: buttonLocationDetails.SESSION_CARD,
                                }}>Нарушения</Button>
                        <Button className={styles.button}
                                onClick={setVisibility.bind(null, showDevicesDialog, setDevicesDialog)}
                                basic
                                ytLog={{
                                    button_name: buttonNameDetails.SHOW_DEVICES,
                                    location: buttonLocationDetails.SESSION_CARD,
                                }}>Устройства</Button>
                        {
                            BlockRules?.OutgoingChat ?
                                <Button className={styles.button}
                                        onClick={setVisibility.bind(null, showAddChatDialog, setAddChatDialog)}
                                        colorType={ButtonTypes.positive}
                                        ytLog={{
                                            button_name: buttonNameDetails.CREATE_CHAT,
                                            location: buttonLocationDetails.SESSION_CARD,
                                        }}>Создать чат</Button>
                                : null
                        }
                        {isLongtermSession
                            ? <Button onClick={setLongtermDialog.bind(null, true)}
                                      disabled={rideFinish}>
                                Рассчитать доср. завершение
                            </Button>
                            : null
                        }
                        {BlockRules?.ShowAddSessionTags
                            ? <Button onClick={setAddModalOpen.bind(null, true)}>
                                + Тег (авто)
                            </Button>
                            : null
                        }
                    </div>
                    <div className={styles.button_group}>
                        {
                            <Button className={styles.button}
                                    onClick={setBonusDialog}
                                    ytLog={{
                                        button_name: buttonNameDetails.BONUS_BUTTON,
                                        location: buttonLocationDetails.SESSION_CARD,
                                    }}>Управление бонусами</Button>
                        }
                        <Button className={styles.button}
                                onClick={setVisibility.bind(null, showEvacuationDialog, setEvacuationDialog)}
                                colorType={ButtonTypes.warning}
                                ytLog={{
                                    button_name: buttonNameDetails.EVACUATION,
                                    location: buttonLocationDetails.SESSION_CARD,
                                }}>
                            Эвакуация
                        </Button>
                        <Button className={styles.button}
                                onClick={finesForm}
                                colorType={ButtonTypes.negative}
                                ytLog={{
                                    button_name: buttonNameDetails.FINES_FORM,
                                    location: buttonLocationDetails.SESSION_CARD,
                                }}>Штрафы (форма)</Button>
                        {showFixCompensateButton && <Button className={styles.button}
                                                            onClick={setVisibility
                                                                .bind(null, showFixCompensate, setFixCompensate)}
                                                            colorType={ButtonTypes.warning}
                                                            ytLog={{
                                                                button_name: buttonNameDetails.FIX_COMPENSATE,
                                                                location: buttonLocationDetails.SESSION_CARD,
                                                            }}>Компенсация Фикса</Button>}
                        <Button className={styles.button}
                                onClick={setVisibility.bind(null, showTagDialog, setTagDialog)}
                                ytLog={{
                                    button_name: buttonNameDetails.ADD_USER_TAG,
                                    location: buttonLocationDetails.SESSION_CARD,
                                }}>Добавить тег (польз.)</Button>
                        <Button className={styles.button}
                                onClick={setVisibility.bind(null, showProtoDialog, setProtoDialog)}
                                colorType={ButtonTypes.positive}
                                ytLog={{
                                    button_name: buttonNameDetails.SESSION_PROTO,
                                    location: buttonLocationDetails.SESSION_CARD,
                                }}>PROTO</Button>
                        {ls.envIsTesting()
                            ? <Button className={styles.button}
                                      colorType={ButtonTypes.warning}
                                      onClick={setVisibility.bind(null, showFine, setFineDialog)}>⚡ штраф ☠</Button>
                            : null
                        }
                        {
                            ls.envIsTesting() || BlockRules?.ShowButtonSessionsTags
                                ? <Button colorType={ButtonTypes.negative}
                                          className={styles.button}
                                          onClick={setVisibility.bind(null, showSessionTagDialog, setSessionTagDialog)}
                                          ytLog={{
                                              button_name: buttonNameDetails.ADD_USER_TAG,
                                              location: buttonLocationDetails.SESSION_CARD,
                                          }}>+ Резкость</Button>
                                : null
                        }
                    </div>
                </div>
                }
            </div>
        </>
    );
};

const mapStateToProps = (store: IStore): IBlockRules => {
    return {
        BlockRules: store.AdminUser && store.AdminUser.blockRules || {},
    };
};

function mapDispatchToProps() {
    return {};
}

export default connect(mapStateToProps, mapDispatchToProps)(SessionCardSidebar);
