import * as React from 'react';

import { EMPTY_DATA, ONE_SECOND } from '../../constants';
import { SessionHistoryInfoHandler } from '../../models/session';
import FormatDate from '../../ui/FormatDate';
import { IconBLE } from '../../ui/Icons';
import * as tblStyles from '../../ui/Table/index.css';
import { SessionContext } from './component';

export const SessionCardTimeline = () => {
    const session = React.useContext(SessionContext);
    const events_0 = SessionHistoryInfoHandler.getEvents.call(session, 0);

    return <div>
        {events_0?.length ? <EventsTable events={events_0}/> : ''}
    </div>;
};

const EventsTable = React.memo((props: { events: any[] }) => {
    const { events } = props;

    return <table className={tblStyles.table}>
        <thead>
            <tr>
                <th>#</th>
                <th>Начало</th>
                <th>Действие</th>
                <th>Тег</th>
                <th>ID события</th>
                <th/>
            </tr>
        </thead>
        <tbody>
            {
                events.map((item, index) => {
                    return (
                        <tr key={index}>
                            <td>{index + 1}</td>
                            <td>
                                <FormatDate withSecond
                                            value={item.timestamp * ONE_SECOND}/>
                            </td>
                            <td>{item.action || EMPTY_DATA}</td>
                            <td>{item.tag_name || EMPTY_DATA}</td>
                            <td>{item.event_id || EMPTY_DATA}</td>
                            <td>{item.transformation_skipped_by_external_command ? <IconBLE/> : ''}</td>
                        </tr>
                    );
                })
            }
        </tbody>
    </table>;
});
