import * as React from 'react';

import SessionsHistoryItem, { SessionHistoryInfoHandler } from '../../models/session';
import { UserInfoHandler } from '../../models/user';
import FormatDate from '../../ui/FormatDate';
import { Link } from '../../ui/Link';
import { buttonLocationDetails, buttonNameDetails } from '../../utils/sendLogs/eventTypes/buttonDetails';
import * as styles from './index.css';
import { Address } from './SessionCardHeader';

interface IBlockProps {
    isSessionStart: boolean;
    session: SessionsHistoryItem;
}

interface IBlockState {
    isDataOpened: boolean;
}

export default class SessionCoordinatesBlock extends React.Component<IBlockProps, IBlockState> {
    state: IBlockState = {
        isDataOpened: false,
    };

    ytLogData = {
        button_name: buttonNameDetails.SHOW_SESSION_COORDINATES,
        user_id: UserInfoHandler.getId.call(SessionHistoryInfoHandler.getUserDetails.call(this.props.session)),
        location: buttonLocationDetails.SESSION_CARD,
    };

    showData() {
        const { isDataOpened } = this.state;

        this.setState({
            isDataOpened: !isDataOpened,
        });
    }

    render() {
        const { session, isSessionStart } = this.props;
        const { isDataOpened } = this.state;

        const deviceDiff = SessionHistoryInfoHandler.getDeviceDiff.call(session);

        const lat = isSessionStart ? deviceDiff?.start?.latitude : deviceDiff?.finish?.latitude;
        const lon = isSessionStart ? deviceDiff?.start?.longitude : deviceDiff?.finish?.longitude;

        const timestamp = isSessionStart
            ? SessionHistoryInfoHandler.getStart.call(session)
            : SessionHistoryInfoHandler.getFinish.call(session);

        return <h5>
            <span className={styles.meta}>{isSessionStart ? 'Начало' : 'Окончание'} сессии:</span>

            <FormatDate value={timestamp} withSecond/>

            <div>
                <Link onClick={this.showData.bind(this)} ytLog={isDataOpened ? this.ytLogData : undefined}>
                    {isDataOpened ? 'Скрыть' : 'Показать'} адрес
                </Link>

                {lat && lon && isDataOpened
                    ? <Address latitude={lat} longitude={lon}/>
                    : null
                }
            </div>
        </h5>;
    }
}
