import moment from 'moment';
import * as React from 'react';

import { EMPTY_DATA, ONE_HOUR_IN_MINUTES, ONE_HUNDRED_PERCENT, ONE_MINUTE, ONE_SECOND } from '../../constants';
import { IOfferProto, ISessionCurrentOffer, SessionHistoryInfoHandler } from '../../models/session';
import FormatDate, { displayDuration, prettySeconds } from '../../ui/FormatDate';
import { rubs } from '../../utils/rubs';
import styles from './index.css';

const colSpan = 2;
const fractionDigits = 2;

export const SessionOffer = (props: {
    isSessionCard?: boolean;
    current_offer: ISessionCurrentOffer;
    offer_proto?: IOfferProto;
    total: string;
    className?: string;
    session?: Record<string, any>;
    BlockRules: any;
}) => {
    const {
        current_offer = {} as ISessionCurrentOffer,
        offer_proto,
        total,
        className,
        isSessionCard,
        BlockRules,
        session,
    } = props;
    const [isCollapsed, setCollapse] = React.useState(isSessionCard);
    const [isCollapsedService, setCollapseService] = React.useState(isSessionCard);
    const additional_durations = current_offer.summary_discount?.details
        && Object.entries(current_offer.summary_discount.details)
            .reduce((prev: any, cur: any) => {
                const temp = [...prev];
                if (cur[1].hasOwnProperty('additional_duration')) {
                    temp.push({ tag_name: cur[1].tag_name, value: cur[1].additional_duration });
                }

                return temp;
            }, [])
        || [];

    const user_proposition = current_offer.user_proposition?.groups?.map((_g: any, _i: number) => {
        const _records = _g.records && _g.records.map((_r: any, __i: number) => {
            return (
                <td colSpan={colSpan}
                    key={_i + '_' + _g.priority + '_' + __i}>
                    {`${_r.name}: ${_r.value}`}
                </td>
            );
        });

        return (
            <td colSpan={colSpan}
                key={_i + '_' + _g.priority}>
                <strong>{_g.name}</strong>: {_records}
            </td>
        );
    });

    const returningDuration = offer_proto && offer_proto.PackOffer && (offer_proto.PackOffer.ReturningDuration
        ? displayDuration(offer_proto.PackOffer.ReturningDuration * ONE_SECOND)
        : 'НЕТ');
    const isLongTerm = offer_proto?.LongTermOffer;

    const sessionStart = SessionHistoryInfoHandler.getStart.call(session);
    let longTermFinish;

    if (SessionHistoryInfoHandler.getExpectedFinish.call(session)) {
        longTermFinish = SessionHistoryInfoHandler.getExpectedFinish.call(session);
    } else {
        const sessionState = SessionHistoryInfoHandler.getSessionState.call(session);
        longTermFinish = sessionState?.until * ONE_SECOND;
    }

    const isService = SessionHistoryInfoHandler.getServicingDuration.call(session);

    const cancellationCost = offer_proto?.LongTermOffer?.CancellationCost
        ? rubs(offer_proto?.LongTermOffer?.CancellationCost)
        : EMPTY_DATA;

    return <table className={`${styles.offer_table} ${className ? className : ''}`}>
        <tbody>
            <tr>
                <td>
                Оффер:
                </td>
                <td>
                    <strong>
                        {current_offer.name || EMPTY_DATA}
                    </strong>
                </td>
            </tr>
            <tr>
                <td>
                Группа тарифов:
                </td>
                <td>
                    <strong>
                        {current_offer.group_name || EMPTY_DATA}
                    </strong>
                </td>
            </tr>
            <tr>
                <td>
                Тариф:
                </td>
                <td>
                поездка:&nbsp;
                    <strong>
                        {current_offer.prices?.riding && rubs(current_offer.prices.riding) || EMPTY_DATA}
                    </strong>
                    <br/>
                ожидание:&nbsp;
                    <strong>
                        {current_offer?.prices?.parking && rubs(current_offer.prices.parking) || EMPTY_DATA}
                    </strong>
                </td>
            </tr>
            {current_offer.free
                ? <tr className={styles.ufo_field}>
                    <td>Бесплатно</td>
                    <td>
                    reservation:&nbsp;
                        <strong>
                            {current_offer.free.reservation
                                && (current_offer.free.reservation / ONE_HOUR_IN_MINUTES).toFixed(fractionDigits)} минут
                        </strong>
                        <br/>
                    acceptance:&nbsp;
                        <strong>
                            {current_offer.free.acceptance
                                && (current_offer.free.acceptance / ONE_HOUR_IN_MINUTES).toFixed(fractionDigits)} минут
                        </strong>
                    </td>
                </tr>
                : null
            }
            {additional_durations && additional_durations.map((item: any, index: number) => {
                return (
                    <tr className={styles.ufo_field}
                        key={item.tag_name + '_' + index}>
                        <td>{item.tag_name}:</td>
                        <td>
                            {item.value > 0
                                ? <b>{moment(item.value * ONE_SECOND).format('mmм ssс')}</b>
                                : <b>{item.value}</b>}
                        </td>
                    </tr>
                );
            })
            }
            {user_proposition &&
        <tr className={styles.ufo_field}>
            {user_proposition}
        </tr> || null
            }
            {current_offer && !current_offer.user_proposition
                ? <tr className={styles.ufo_field}>
                    <td colSpan={colSpan}>
                        {current_offer.prices?.free_reservation
                            ? <div>
                                {current_offer.prices
                                    ?.free_reservation / ONE_MINUTE * ONE_SECOND} мин бесплатного ожидания
                            </div>
                            : current_offer.short_description?.map((desc, index) => {
                                return (
                                    <div key={index}>
                                        {desc}
                                    </div>
                                );
                            })}
                    </td>
                </tr>
                : null
            }
            {returningDuration &&
        <tr className={styles.ufo_field}>
            <td>Пересчет при завершении раньше: {returningDuration}</td>
        </tr> || null
            }
            {
                isLongTerm ? <>
                    <tr>
                        <td colSpan={colSpan} className={styles.block_title}>
                            <strong>Подписка {current_offer.name || EMPTY_DATA}:</strong>
                        </td>
                    </tr>
                    <tr>
                        <td>Полная страховка</td>
                        <td>{!offer_proto?.LongTermOffer.Franchise ? <strong>ДА</strong> : 'НЕТ'}</td>
                    </tr>

                    <tr>
                        <td>Начало аренды</td>
                        <td className={styles.lt_data}><FormatDate value={sessionStart}/></td>
                    </tr>
                    <tr>
                        <td>Окончание аренды</td>
                        <td className={styles.lt_data}><FormatDate value={longTermFinish}/></td>
                    </tr>

                    <tr>
                        <td>Детское кресло</td>
                        <td>{offer_proto?.LongTermOffer?.ChildSeat ? <strong>ДА</strong> : 'НЕТ'}</td>
                    </tr>
                    <tr>
                        <td>Отмена до приемки</td>
                        <td>{cancellationCost}</td>
                    </tr>
                    <tr>
                        <td>Отмена после приемки</td>
                        <td>{rubs(offer_proto?.LongTermOffer?.EarlyReturnCost)}</td>
                    </tr>
                </> : null
            }
            <tr>
                <td>Кешбэк при соблюдении тарифа:</td>
                <td>{offer_proto?.CashbackPercent ? offer_proto.CashbackPercent + '%' : EMPTY_DATA}</td>
            </tr>

            <tr onClick={setCollapse.bind(null, !isCollapsed)}>
                <td colSpan={colSpan}
                    className={`${styles.block_title} ${isCollapsed ? styles.collapsed : ''}`}>
                Стоимость перерасхода без скидок
                </td>
            </tr>
            {!isCollapsed && <>
                <tr>
                    <td>МИН:</td>
                    <td>
                    поездка:&nbsp;
                        <strong>
                            {current_offer?.prices?.riding && rubs(current_offer.prices.riding) || EMPTY_DATA}
                        </strong>
                        <br/>
                    ожидание:&nbsp;
                        <strong>
                            {current_offer.prices?.parking && rubs(current_offer.prices.parking) || EMPTY_DATA}
                        </strong>
                    </td>
                </tr>
                <tr>
                    <td className={styles.block_last_el}>
                    КМ:
                    </td>
                    <td className={styles.block_last_el}>
                        <strong>
                            {offer_proto && offer_proto.PackOffer && offer_proto.PackOffer.RerunPriceKM &&
                        rubs(offer_proto.PackOffer.RerunPriceKM)
                        || current_offer?.prices?.km && rubs(current_offer.prices.km)
                        || EMPTY_DATA}
                        </strong>
                    </td>
                </tr>
            </>}

            {
                isService && <tr onClick={setCollapseService.bind(null, !isCollapsedService)}>
                    <td colSpan={colSpan}
                        className={`${styles.block_title} ${isCollapsedService ? styles.collapsed : ''}`}>
                    Сервисный режим
                    </td>
                </tr>
            }
            {
                isService && (!isCollapsedService && <>
                    <tr>
                        <td>Длительность</td>
                        <td>{prettySeconds(SessionHistoryInfoHandler.getServicingDuration.call(session))}</td>
                    </tr>
                    <tr>
                        <td>Вычли из итоговой цены</td>
                        <td>{rubs(SessionHistoryInfoHandler.getServicingOmittedPrice.call(session))}</td>
                    </tr>
                </>)
            }
            {current_offer.discounts && current_offer.discounts.map((discount: any, index: number) => {
                return discount.discount ? (
                    <tr key={index}>
                        <td>{discount.title || 'noname скидка'}</td>
                        <td>
                            <strong>{discount.discount
                                && (discount.discount * ONE_HUNDRED_PERCENT).toFixed(0)}%</strong>
                        </td>
                    </tr>
                ) : undefined;
            }) || null}
            <tr>
                <td colSpan={colSpan}
                    className={styles.block_title}>
                Стоимость перерасхода со скидками
                </td>
            </tr>
            <tr>
                <td>МИН:</td>
                <td>
                поездка:&nbsp;
                    <strong>
                        {current_offer.prices?.riding_discounted &&
                    rubs(current_offer.prices.riding_discounted) || EMPTY_DATA}
                    </strong>
                    <br/>
                ожидание:&nbsp;
                    <strong>
                        {current_offer.prices?.parking_discounted &&
                    rubs(current_offer.prices.parking_discounted) || EMPTY_DATA}
                    </strong>
                </td>
            </tr>
            <tr>
                <td className={styles.block_last_el}>
                КМ:
                </td>
                <td className={styles.block_last_el}>
                    <strong>
                        {current_offer.rerun_price_km && rubs(current_offer.rerun_price_km)
                    || current_offer?.prices?.km_discounted && rubs(current_offer.prices.km_discounted)
                    || EMPTY_DATA}
                    </strong>
                </td>
            </tr>
            <tr>
                <td>
                Варианты оплаты:
                </td>
                <td>
                    {offer_proto && offer_proto.ChargableAccounts
                && Array.isArray(offer_proto.ChargableAccounts)
                && offer_proto.ChargableAccounts.map((item: string, index: number) => {
                    return item === offer_proto!.SelectedCharge
                        ? <strong key={index}>{item}; </strong>
                        : <span key={index}>{item}; </span>;
                })}
                </td>
            </tr>
            {!(current_offer && current_offer.name && current_offer.name.includes('Центр')) &&
        <tr>
            <td>Первоначальная стоимость:</td>
            <td>
                <strong>
                    {offer_proto && offer_proto.PackOffer && offer_proto.PackOffer.PackPrice
                    && rubs(offer_proto.PackOffer.PackPrice) || EMPTY_DATA}
                </strong>
            </td>
        </tr> || null
            }
            <tr>
                <td>
                Радар:
                </td>
                <td>
                    <strong>
                        {offer_proto && offer_proto.FromScanner && <strong>ДА</strong> || EMPTY_DATA}
                    </strong>
                </td>
            </tr>
            {
                offer_proto?.PackOffer && (offer_proto?.FixPointOffer ? BlockRules?.TariffDetails : true)
            && <>
                <tr>
                    <td>
                        Включено:
                    </td>
                    <td>
                        {displayDuration((offer_proto.PackOffer.Duration
                            && offer_proto.PackOffer.Duration * ONE_SECOND || 0),
                        )}/
                        {
                            +(offer_proto.PackOffer.MileageLimit || 0)
                        }км

                    </td>
                </tr>
                <tr>
                    <td> Дополнительно:</td>
                    <td>
                        {
                            displayDuration((offer_proto.PackOffer.ExtraDuration
                                && offer_proto.PackOffer.ExtraDuration * ONE_SECOND || 0))}/
                        {
                            (offer_proto.PackOffer.ExtraMileageLimit || 0)
                        }км

                    </td>
                </tr>
                <tr>
                    <td><strong>Включено.Итого:</strong></td>
                    <td>
                        <strong>
                            {<strong>
                                {displayDuration((offer_proto.PackOffer.Duration
                                    && offer_proto.PackOffer.Duration * ONE_SECOND || 0)
                                    + (offer_proto.PackOffer.ExtraDuration
                                        && offer_proto.PackOffer.ExtraDuration * ONE_SECOND || 0))}</strong>}/
                            {
                                (offer_proto.PackOffer.MileageLimit || 0)
                                + (offer_proto.PackOffer.ExtraMileageLimit || 0)
                            }км
                        </strong>
                    </td>
                </tr>
            </> || null
            }
            {total &&
        <tr>
            <td colSpan={colSpan}>
                <strong>Итого: </strong>
                {total}
            </td>
        </tr> || null
            }
        </tbody>
    </table>;
};
