import * as React from 'react';
import { useSelector } from 'react-redux';

import { Dict } from '../../../../../types';
import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../../constants';
import SessionsHistoryItem, { SessionHistoryInfoHandler } from '../../../../models/session';
import { Button, ButtonTypes } from '../../../../ui/Button';
import { Link } from '../../../../ui/Link';
import { getRawSetting2 } from '../../../../utils/getRawSetting';
import { buttonLocationDetails, buttonNameDetails } from '../../../../utils/sendLogs/eventTypes/buttonDetails';
import { billingCalculatorOfferNamesKey } from '../../../InterfaceAdminConfig/adminConfigKeys';
import { BillingCalculator } from '../BillingCalculator';

interface IBillingCalculatorButtonProps {
    className?: string;
    isLink?: boolean;
    since?: number;
    onClick?: (value?: unknown) => void;
    location: buttonLocationDetails;
    session: SessionsHistoryItem;
    BlockRules: Dict<boolean>;
}

export const BillingCalculatorButton = (props: React.PropsWithChildren<IBillingCalculatorButtonProps>) => {
    const { className, isLink, since, BlockRules, session, location, children, onClick } = props;
    const [isShowingCalculator, showCalculator]= React.useState(false);
    const [isShowingButton, showButton] = React.useState(false);
    const billingCalculatorOfferNames =
        useSelector((store) => {
            return getRawSetting2(store, `${GVARS_INTERFACE_ADMIN_PREFIX}.${billingCalculatorOfferNamesKey}`)
                ?.map((offerName) => offerName.offer_name.trim());
        });

    /* if user has BlockRules.LimitedCalculator, check offerNames and show, else always show */
    React.useEffect(() => {
        const shouldShowButton = billingCalculatorOfferNames
            ?.includes(SessionHistoryInfoHandler.getOfferName.call(session));
        showButton(BlockRules?.LimitedCalculator ? !!shouldShowButton : true);
    }, [session]);

    return <>
        {isShowingButton
            ? <>
                {isShowingCalculator
                    ? <BillingCalculator BlockRules={BlockRules}
                                         session={session}
                                         since={since}
                                         onClose={showCalculator.bind(null, false)}/>
                    : null
                }
                {isLink
                    ? <Link onClick={() => {
                        onClick?.();
                        showCalculator(true);
                    }}
                            ytLog={{
                                button_name: buttonNameDetails.BILLING_CALCULATOR,
                                location,
                            }}>
                        {children}
                    </Link>
                    : <Button className={className}
                              onClick={() => {
                                  onClick?.();
                                  showCalculator(true);
                              }}
                              colorType={ButtonTypes.positive}
                              ytLog={{
                                  button_name: buttonNameDetails.BILLING_CALCULATOR,
                                  location,
                              }}>
                        {children}
                    </Button>
                }
            </>
            : null}
    </>;
};
