import * as React from 'react';

import { Button } from '../../../ui/Button';
import { Window } from '../../../ui/FullModal';
import { Request2 } from '../../../utils/request';
import { FormConstructor } from '../../FormConstructor';
import { REQUESTS, SESSION_REQUESTS } from '../request';
import { FINE_SCHEMA } from './fine_schema';

export class FineDialog extends React.Component<any, any> {
    data: any = null;
    state = {
        isLoading: false,
        error: null,
    };
    request = new Request2({ requestConfigs: SESSION_REQUESTS });

    onChange(data) {
        this.data = data;
    }

    setFine() {
        this.setState({
            isLoading: true,
            error: null,
        }, () => {
            this.request.exec(REQUESTS.SET_FINE, {
                body: {
                    data: [this.data],
                },
            })
                .then(() => {
                    this.setState({
                        isLoading: false,
                    });
                    this.props.onClose();
                })
                .catch((error) => {
                    this.setState({
                        isLoading: false,
                        error,
                    });
                });
        });
    }

    render() {
        return <Window title={`Тестовое навешивание штрафа`}
                       onClose={this.props.onClose.bind(this)}
                       error={this.state.error}>
            <FormConstructor schema={FINE_SCHEMA}
                             onChange={this.onChange.bind(this)}
                             initialData={this.props}/>
            <Button onClick={this.setFine.bind(this)} isLoading={this.state.isLoading}>Штрафануть</Button>
        </Window>;
    }
}
