import { controlType, SchemaItemVisual } from '../../FormConstructor/types';

export const FINE_SCHEMA = {
    article_koap: {
        type: controlType.string,
        display_name: 'article_koap',
        order: 1,
        required: true,
        default: '12.16.1 - Несоблюдение требований',
    },
    car_id: { type: controlType.string, display_name: 'car_id', order: 1, required: true },
    session_id: { type: controlType.string, display_name: 'session_id', order: 2 },
    user_id: { type: controlType.string, display_name: 'user_id', order: 2 },

    ruling_date: {
        type: controlType.string,
        display_name: 'ruling_date',
        order: 2,
        default: '2019-12-17',
    },
    ruling_number: {
        type: controlType.string,
        display_name: 'ruling_number',
        order: 2,
        default: '1881017719000000000X',
    },
    sum_to_pay: {
        type: controlType.numeric,
        visual: SchemaItemVisual.RUBS,
        display_name: 'sum_to_pay', order: 2, default: 100,
    },
    sum_to_pay_without_discount: {
        type: controlType.numeric,
        visual: SchemaItemVisual.RUBS,
        display_name: 'sum_to_pay_without_discount',
        order: 2,
        default: 200,
    },
    violation_place: { type: controlType.string, display_name: 'violation_place', order: 2, default: 'тут' },
    violation_time: {
        type: controlType.string,
        display_name: 'violation_time',
        order: 2,
        default: '2019-12-15T15:00:00+0300',
    },
    is_camera_fixation: { type: controlType.bool, display_name: 'is_camera_fixation', order: 2, default: true },
    needs_charge: { type: controlType.bool, display_name: 'needs_charge', order: 2, default: true },
};
