import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export enum REQUESTS {
    GET_SESSION = 'GET_SESSION',
    GET_BILLING_INFO = 'GET_BILLING_INFO',
    GET_CALCULATIONS = 'GET_CALCULATIONS',
    GET_CAR_TAGS = 'GET_CAR_TAGS',
    GET_CAR_TAGS_HISTORY = 'GET_CAR_TAGS_HISTORY',
    GET_SCHEME_REPORT_EVACUATION_PLUS = 'GET_SCHEME_REPORT_EVACUATION_PLUS',
    REPORT_EVACUATION_PLUS = 'REPORT_EVACUATION_PLUS',
    REPORT_EVACUATION = 'REPORT_EVACUATION',
    GET_USER_HISTORY_TAGS = 'GET_USER_HISTORY_TAGS',
    GET_TAGS = 'GET_TAGS',
    GET_USER_TAGS = 'GET_USER_TAGS',
    ATTACH_USER_TAG = 'ATTACH_USER_TAG',
    SET_FINE = 'SET_FINE',
    TAG_LIST = 'TAG_LIST',

}

export const SESSION_REQUESTS: IComponentRequest = {
    [REQUESTS.SET_FINE]: {
        api: 'user/fines/upsert',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.GET_SESSION]: {
        api: 'sessions/history',
        cgiObj: {
            numdoc: null,
            session_id: null,
            user_id: null,
        },
    },
    [REQUESTS.GET_BILLING_INFO]: {
        api: 'billing/payment/info',
        cgiObj: {
            session_id: null,
            details: 'yes',
            since: null,
            until: null,
        },
    },

    [REQUESTS.GET_CALCULATIONS]: {
        method: REQUEST_METHOD.POST,
        api: 'billing/calculator',
        cgiObj: {
            use_compiled: null,
        },
    },
    [REQUESTS.GET_CAR_TAGS]: {
        api: 'car/tag/list',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_CAR_TAGS_HISTORY]: {
        api: 'car/tag/history',
        cgiObj: {
            car_id: null,
            since: null,
            until: null,
        },
    },
    [REQUESTS.GET_SCHEME_REPORT_EVACUATION_PLUS]: {
        api: 'incident/initiate_evacuation',
        cgiObj: {
            scheme: null,
        },
    },
    [REQUESTS.REPORT_EVACUATION_PLUS]: {
        api: 'incident/initiate_evacuation',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.REPORT_EVACUATION]: {
        apiPrefix: API_PREFIXES._OLD_PY_V1,
        method: REQUEST_METHOD.POST,
        api: 'incident/evacuation/',
    },
    [REQUESTS.GET_USER_HISTORY_TAGS]: {
        api: 'users/tags_history',
        cgiObj: {
            object_id: null,
            duration: null,
            since: null,
            until: null,
        },
    },
    [REQUESTS.GET_TAGS]: {
        api: 'tag/description/list',
    },
    [REQUESTS.GET_USER_TAGS]: {
        api: 'user_tags/list',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.ATTACH_USER_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'user_tags/add',
    },
    [REQUESTS.TAG_LIST]: {
        api: 'trace/tag/list',
        cgiObj: {
            object_id: null,
        },
    },
};
