import React from 'react';

import { Button } from '../../../ui/Button';
import { FormConstructor } from '../../FormConstructor';
import styles from './index.css';
import schema from './schema';

interface IIdentifyForShowingProps {
    onIdentify: (supportAnswers) => void;
}

interface IAnswer extends Object {
    comment?: string;
    status: IAnswerStatus;
}

enum IAnswerStatus {
    has_verified = 'has_verified',
    has_not_verified = 'has_not_verified'
}

export default function IdentifyForShowing(props: IIdentifyForShowingProps) {
    const [data, onChangeData] = React.useState<IAnswer>({} as IAnswer);
    const [isValid, onChangeValid] = React.useState(false);
    const [hasChanged, onChange] = React.useState(false);

    const _onChange = (data, isValid, hasChanged) => {
        onChangeData(data);
        onChangeValid(isValid);
        onChange(hasChanged);
    };

    React.useEffect(() => {
        if (data.status === IAnswerStatus.has_not_verified && !data.comment) {
            onChangeValid(false);
        }
    }, [data]);

    return <div className={styles.component}>
        <div className={styles.text}>
            <div>Отметьте, что <span className={styles.strong}>провели идентификацию</span> и консультируете именно
                этого
                клиента.
            </div>
            <div>Не забывайте, что список сессий и детали поездок — это тоже <span className={styles.strong}>NDA</span>.
            </div>
            <div> Если нужно просмотреть сессии по другой причине, отметьте это в комментарии.</div>
        </div>
        <FormConstructor hideChanges
                         schema={schema}
                         onChange={_onChange.bind(null)}/>
        <Button onClick={props.onIdentify.bind(null, data)}
                disabled={!hasChanged || !isValid}
                className={styles.submit}>Провести
            идентификацию</Button>
    </div>;
}
