import { Dict } from '../../../../types';
import { controlType, ISchemaItem } from '../../FormConstructor/types';

const schema: Dict<ISchemaItem> = {
    'status': {
        type: controlType.variable,
        display_name: '',
        'control_field': {
            'status': {
                'type': controlType.variants,
                'variants': [
                    {
                        text: 'Верифицирован',
                        value: 'has_verified',
                        description: '🟢 Верификация проведена, общаюсь с этим пользователем',
                    },
                    {
                        text: 'Не верифицирован',
                        value: 'has_not_verified',
                        description: '🟠 Верификация не проведена, но нужно просмотреть, напишу коммент',
                    },
                ],
                'display_name': 'Статус верификации',
            },
        },
        'variants_fields': {
            'has_not_verified': {
                'comment': {
                    required: true,
                    'type': controlType.text,
                    'display_name': 'Комментарий',
                },
            },
        },
    },
};

export default schema;
