import moment from 'moment';
import React from 'react';
import { connect } from 'react-redux';

import { Dict } from '../../../../types';
import { ONE_SECOND } from '../../../constants';
import { Button, ButtonTypes } from '../../../ui/Button';
import DatePicker from '../../../ui/DatePicker';
import { Link } from '../../../ui/Link';
import { buttonLocationDetails, buttonNameDetails } from '../../../utils/sendLogs/eventTypes/buttonDetails';
import { IStore } from '../../App/store';
import style from './index.css';

const SINCE = 'since';
const UNTIL = 'until';

interface ISessionsListHeaderProps {
    onChangeDates: (field, value) => void;
    downloadPassportInfo: () => void;
    downloadCarSessions: () => void;
    isWorking: boolean;
    BlockRules: Dict<any>;
    userId: string | null;
    carId: string | null;
}

interface ISessionsListHeaderState {
    [key: string]: any;
}

class SessionsListHeader extends React.Component<ISessionsListHeaderProps, ISessionsListHeaderState> {
    state = {
        [SINCE]: null,
        [UNTIL]: null,
    };

    changeDate(field, value) {
        this.props.onChangeDates(field, Math.floor(value / ONE_SECOND));
        this.setState({
            [field]: value,
        });
    }

    getTrackUrl(since: number) {
        return `#/tracks?since=${since}&user_id=${this.props.userId}&status=`;
    }

    showUserTracksHistory() {
        const monthAgo = (+moment().subtract(1, 'month'));
        location.href = this.getTrackUrl(monthAgo);
    }

    render() {
        return <div className={style.component}>
            <div className={style.dates}>
                {this.props.BlockRules?.ViewAllSession && <>
                    <div className={style.date_item}>
                        <DatePicker value={this.state[SINCE]}
                                    onChange={this.changeDate.bind(this, SINCE)}
                                    placeholder={'C'}/>
                    </div>
                    <div className={style.date_item}>
                        <DatePicker value={this.state[UNTIL]}
                                    onChange={this.changeDate.bind(this, UNTIL)}
                                    placeholder={'По'}/>
                    </div>
                </>
                }
            </div>
            {
                this.props?.BlockRules?.PassportDownload
                && <Button isLoading={this.props.isWorking}
                           ytLog={{ button_name: buttonNameDetails.PERSONAL_DATA_DOWNLOAD }}
                           onClick={this.props.downloadPassportInfo.bind(this)}>ПДН в XLSX</Button>
            }
            {
                this.props?.BlockRules?.UserTracks && this.props.userId &&
                <Link onClick={this.showUserTracksHistory.bind(this)}
                      ytLog={{
                          button_name: buttonNameDetails.SHOW_TRACKS,
                          location: buttonLocationDetails.CLIENT_CARD,
                      }}>
                    Треки пользователя
                </Link> || null
            }
            {
                this.props.carId && this.props.BlockRules && this.props.BlockRules.SessionsDownload
                && <Button onClick={this.props.downloadCarSessions.bind(this)}
                           colorType={ButtonTypes.positive}
                           ytLog={{ button_name: buttonNameDetails.CAR_SESSIONS_DOWNLOAD }}>СЕССИИ в XLSX</Button>
            }
        </div>;
    }
}

const mapStateToProps = (store: IStore) => {
    return { BlockRules: store?.AdminUser?.blockRules };
};

export default connect(mapStateToProps)(SessionsListHeader);
export { SessionsListHeader };
