import { Dict } from '../../../types';
import { IComponentRequest } from '../../utils/request';

export const REQUESTS: Dict<any> = {
    SESSION_HISTORY: 'SESSION_HISTORY',
    GET_USER_INFO: 'GET_USER_INFO',
    GET_USER_TAGS_BY_PERFORMER: 'GET_USER_TAGS_BY_PERFORMER',
};

export const SESSIONS_LIST_REQUESTS: IComponentRequest = {
    [REQUESTS.SESSION_HISTORY]: {
        api: 'sessions/history',
        cgiObj: {
            numdoc: null,
            ts_since: null,
            ts_supreme: null,
            user_id: null,
            car_id: null,
            session_id: null,
        },
    },
    [REQUESTS.GET_USER_INFO]: {
        api: 'user/info',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_USER_TAGS_BY_PERFORMER]: {
        api: 'tags/by_performer',
        cgiObj: {
            performer: null,
        },
    },
};
