import { Dict } from '../../../../../types';
import { FRONT_OPTIONS_KEY, ROOT_KEY } from '../constants';
import { Node } from './constants';

export class ActionsTree {
    _root: Node = {} as Node;

    constructor(data: Dict<any> ) {
        this._root = new Node(data);
    }

    traverse(cb: (node: Node) => void) {
        (function recurse(currentNode: Node) {
            currentNode.children.forEach(node => recurse(node));
            cb(currentNode);
        })(this._root);
    }

    filter(action_type: string) {
        return this._root.children.filter(item => {
            return item.data?.action_type === action_type;
        });
    }

    add(data: Dict<any> , toData: string, options?: Dict<any> ) {
        if (data[FRONT_OPTIONS_KEY]) {
            delete data[FRONT_OPTIONS_KEY];
        }

        const child = new Node(data, options);

        let parent: Node | null = null;

        const callback = (node: Node) => {
            if (node.data?.action_id === toData) {
                parent = node;
            }
        };

        this.traverse(callback);

        if (parent) {
            const existingParent: Node = parent;
            existingParent.children.push(child);
            child.parent = parent;
        } else {
            console.error(`can't add node: ${data.action_id}:${toData}`);
            this.add(data, ROOT_KEY, { unlinked: true });
        }
    }
}
