import * as React from 'react';

import { Dict } from '../../../../../types';
import { EMPTY_DATA } from '../../../../constants';
import { Button, CancelButton } from '../../../../ui/Button';
import { Window } from '../../../../ui/FullModal';
import * as coreStyle from '../../../../ui/index.css';
import { Input } from '../../../../ui/Input';
import { Request2 } from '../../../../utils/request';
import { REQUESTS, SETTINGS_REQUESTS } from '../request';

interface IPropositionConfirmModalProps {
    newTariffInfo: Dict<any>;
    onClose: (isSuccess: boolean) => void;
    triggerCopyModal: () => void;
}

interface IPropositionConfirmModalState {
    propositionComment: string;
    isAddingProposition: boolean;
    error: Error | null;
    liteConfirmLink: string;
}

export default class PropositionConfirmModal extends
    React.Component<IPropositionConfirmModalProps, IPropositionConfirmModalState> {
    state = {
        propositionComment: '',
        isAddingProposition: false,
        error: null,
        liteConfirmLink: '',
    };
    request = new Request2({ requestConfigs: SETTINGS_REQUESTS });

    componentDidMount(): void {
        if (this.props.newTariffInfo && this.props.newTariffInfo.diff) {
            const { ridingPriceDiff, parkingPriceDiff, packPriceDiff } = this.props.newTariffInfo.diff;

            const ridingDiffString = ridingPriceDiff
                ? `Riding: ${ridingPriceDiff > 0 ? '+' : ''}${ridingPriceDiff}%`
                : '';
            const parkingDiffString = parkingPriceDiff
                ? `Parking: ${parkingPriceDiff > 0 ? '+' : ''}${parkingPriceDiff}%`
                : '';
            const packDiffString = packPriceDiff
                ? `Pack: ${packPriceDiff > 0 ? '+' : ''}${packPriceDiff}%`
                : '';

            const propositionComment = [ridingDiffString, parkingDiffString, packDiffString]
                .filter((diff: string) => diff).join(', ');

            this.setState({ propositionComment });
        }
    }

    onChangePropositionComment(propositionComment: string) {
        this.setState({ propositionComment });
    }

    addProposition() {
        const propositionComment = encodeURIComponent(this.state.propositionComment)
            || `proposition_${new Date().getTime()}`;
        this.setState({ isAddingProposition: true }, () => {
            this.request.exec(REQUESTS.ADD_ACTION_PROPOSE, {
                queryParams: { comment: propositionComment },
                body: this.props.newTariffInfo.newTariff,
            })
                .then(() => {
                    this.setState({ isAddingProposition: false });
                    this.props.onClose(false);
                    this.props.triggerCopyModal();
                })
                .catch((error) => {
                    this.setState({ error, isAddingProposition: false });
                });
        });
    }

    render() {
        return <Window error={this.state.error}
                       title={`Добавить предложение к экшену ${this.props.newTariffInfo.newTariff
                       && this.props.newTariffInfo.newTariff.action_description || EMPTY_DATA}`}
                       onClose={this.props.onClose.bind(this, false)}>
            <div>
                <Input value={this.state.propositionComment}
                       placeholder={'Комментарий'}
                       onChange={this.onChangePropositionComment.bind(this)}/>
                <div className={coreStyle.button_container}>
                    <CancelButton onClick={this.props.onClose.bind(this, false)}/>
                    <Button onClick={this.addProposition.bind(this)}
                            disabled={this.state.isAddingProposition || !this.state.propositionComment}>
                        Предложить
                    </Button>
                </div>
            </div>
        </Window>;
    }
}
