import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export const REQUESTS: { [key: string]: string } = {
    GET_ACTIONS: 'GET_ACTIONS',
    REMOVE_ACTIONS: 'REMOVE_ACTIONS',
    ADD_ACTIONS: 'ADD_ACTIONS',
    GET_ROLES: 'GET_ROLES',
    DELETE_ROLES_ACTIONS: 'DELETE_ROLES_ACTIONS',
    PROPOSITION_CONFIRM: 'PROPOSITION_CONFIRM',
    PROPOSITION_REJECT: 'PROPOSITION_REJECT',
    ADD_ACTION_PROPOSE: 'ADD_ACTION_PROPOSE',
};

export const SETTINGS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_ACTIONS]: {
        api: 'actions/list',
        cgiObj: {
            action_id: null,
            report: null, //compact
        },
    },
    [REQUESTS.REMOVE_ACTIONS]: {
        api: 'actions/remove',
        cgiObj: {
            actions: null,
        },
    },
    [REQUESTS.GET_ROLES]: {
        api: 'roles/list',
        cgiObj: {
            action_id: null,
        },
    },
    [REQUESTS.DELETE_ROLES_ACTIONS]: {
        api: 'roles/actions/remove',
        cgiObj: {
            role: null,
            actions: null,
            roles: null,
        },
    },
    [REQUESTS.ADD_ACTION]: {
        method: REQUEST_METHOD.POST,
        api: 'actions/add',
    },
    [REQUESTS.PROPOSITION_CONFIRM]: {
        method: REQUEST_METHOD.POST,
        api: 'actions/confirm',
    },
    [REQUESTS.PROPOSITION_REJECT]: {
        method: REQUEST_METHOD.POST,
        api: 'actions/reject',
    },
    [REQUESTS.ADD_ACTION_PROPOSE]: {
        method: REQUEST_METHOD.POST,
        api: `actions/propose`,
        cgiObj: {
            comment: null,
        },
    },
};
