import { Dict } from '../../../../types';
import { IRole } from '../../Clients/UserRolesView/types';

export interface IActionCommon {
    action_description: string;
    action_id: string;
    action_meta: Dict<any>;
    action_revision: number;
    action_type: string;
    deprecated: boolean;
    enabled: boolean;
}

export interface IAction extends IActionCommon {
    parent?: string;
    propositions: IActionProposition[];
    is_proposition_only?: boolean;
}

export interface IActionProposition extends IActionCommon {
    confirmations: string[];
    confirmations_count: number;
    confirmations_need: number;
    confirmators: string[];
    proposition_author: string;
    proposition_description: string;
    proposition_id: string;
}

export interface IRolesInfo {
    isRolesLoading: boolean;
    rolesError: Error | null;
    parentRoles: Record<string, string[]>;
    actionRoles: Record<string, IRole[]>;
}
